package com.bxm.fossicker.order.timer;

import com.bxm.fossicker.order.facade.service.SynchronizeOrderService;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;

/**
 * @Author: pf.w
 * @Date: 2019/12/4 16:28
 */
@Component
@Log4j2
public class UpdateOrderStatusTask extends AbstractCronTask<String> {

    @Autowired
    private SynchronizeOrderService synchronizeOrderService;

    @Override
    protected ReturnT<String> service(String s) {
        try {
            log.info("----------同步渠道订单状态开始   start : {}", LocalDateTime.now());
            //同步渠道订单状态
            synchronizeOrderService.synchronOrderStatus();
            log.info("-----------同步渠道订单状态结束   end :{}", LocalDateTime.now());
            log.info("----------同步常规订单状态开始   start : {}", LocalDateTime.now());
            //后续同步常规订单
            synchronizeOrderService.synchronGeneralOrderStatus();
            log.info("-----------同步常规订单状态结束   end :{}", LocalDateTime.now());
        } catch (Exception e) {
            log.error("同步订单状态开始,异常为:", e);
        }
        return ReturnT.SUCCESS;
    }

    @Override
    public String taskName() {
        return "同步订单信息";
    }

    @Override
    public String cron() {
        //每天凌晨12:10分开始
        return "0 10 0 * * ?";
    }
}
