package com.bxm.game.common.dal.autoconfigure;

import com.baomidou.mybatisplus.core.parser.ISqlParser;
import com.baomidou.mybatisplus.extension.parsers.DynamicTableNameParser;
import com.baomidou.mybatisplus.extension.parsers.ITableNameHandler;
import com.baomidou.mybatisplus.extension.plugins.PaginationInterceptor;
import com.bxm.game.common.dal.entity.AcquiredPropLog;
import com.bxm.game.common.dal.entity.AssetsLog;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.ibatis.reflection.MetaObject;
import org.springframework.context.annotation.Bean;

import java.util.List;
import java.util.Map;

/**
 * @author allen
 * @date 2020-04-15
 * @since 1.0
 */
public class MyBatisPlusAutoConfiguration {

    @Bean
    public PaginationInterceptor paginationInterceptor() {
        DynamicTableNameParser dynamicTableNameParser = new DynamicTableNameParser();

        Map<String, ITableNameHandler> tableNameHandlerMap = Maps.newHashMap();
        tableNameHandlerMap.put(AcquiredPropLog.TABLE_NAME_DYNAMIC_MAPPING, new ITableNameHandler() {
            @Override
            public String dynamicTableName(MetaObject metaObject, String sql, String tableName) {
                return AcquiredPropLog.getTableName();
            }
        });
        tableNameHandlerMap.put(AssetsLog.TABLE_NAME_DYNAMIC_MAPPING, new ITableNameHandler() {
            @Override
            public String dynamicTableName(MetaObject metaObject, String sql, String tableName) {
                return AssetsLog.getTableName();
            }
        });
        dynamicTableNameParser.setTableNameHandlerMap(tableNameHandlerMap);
        List<ISqlParser> parsers = Lists.newArrayList(dynamicTableNameParser);
        PaginationInterceptor interceptor = new PaginationInterceptor();
        interceptor.setSqlParserList(parsers);
        return interceptor;
    }
}
