package com.bxm.game.common.dal.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.bxm.game.common.dal.BaseEntity;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 
 * </p>
 *
 * @author Allen Hu
 * @since 2021-01-12
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(AssetsLog.TABLE_NAME_DYNAMIC_MAPPING)
public class AssetsLog extends BaseEntity {

    private static final long serialVersionUID = 1L;

    public static final String TABLE_NAME_DYNAMIC_MAPPING = "DynamicMappingForAssetsLog";
    public static final String TABLE_NAME_PREFIX = "assets_log_";

    /**
     * 流水号
     */
    private String assetsNo;

    /**
     * appid
     */
    private String appId;

    /**
     * 变现猫用户ID
     */
    private String uid;

    /**
     * app用户ID
     */
    private String appUid;

    /**
     * 活动类型
     */
    private String activityType;

    /**
     * 资产类型
     */
    private String assetType;

    /**
     * 资产数量
     */
    private Integer assetNum;

    /**
     * 操作类型,1:增加,2:扣除
     */
    private Integer operateType;

    /**
     * 操作状态,1:成功,2:失败
     */
    private Integer operateStatus;

    /**
     * 接口调用状态,1:正常,2:错误,3:超时
     */
    private Integer apiStatus;

    private LocalDateTime createTime;


    public static final String ASSETS_NO = "assets_no";

    public static final String APP_ID = "app_id";

    public static final String UID = "uid";

    public static final String APP_UID = "app_uid";

    public static final String ACTIVITY_TYPE = "activity_type";

    public static final String ASSET_TYPE = "asset_type";

    public static final String ASSET_NUM = "asset_num";

    public static final String OPERATE_TYPE = "operate_type";

    public static final String OPERATE_STATUS = "operate_status";

    public static final String API_STATUS = "api_status";

    public static final String CREATE_TIME = "create_time";

    public static String getTableName() {
        return getTableName(0);
    }

    public static String getTableName(int daysToAdd) {
        return TABLE_NAME_PREFIX + LocalDate.now().plusDays(daysToAdd).format(DateTimeFormatter.ofPattern("yyyyMMdd"));
    }

}
