package com.bxm.game.common.dal.service.impl;

import com.bxm.game.common.dal.entity.AssetsLog;
import com.bxm.game.common.dal.mapper.AssetsLogMapper;
import com.bxm.game.common.dal.service.IAssetsLogService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author Allen Hu
 * @since 2021-01-12
 */
public class AssetsLogServiceImpl extends ServiceImpl<AssetsLogMapper, AssetsLog> implements IAssetsLogService {

    @Override
    public boolean isExists(String databaseName, String tableName) {
        return getBaseMapper().checkTableExists(databaseName, tableName) > 0;
    }

    @Override
    public void createTable(String tableName) {
        getBaseMapper().createTable(tableName);
    }

    @Override
    public void createTableIfNecessary(String databaseName, String tableName) {
        if (!isExists(databaseName, tableName)) {
            createTable(tableName);
        }
    }
}
