package com.bxm.game.common.dal.model;

import java.util.Date;

import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 货币记录<br/>
 *
 * @author kerry.jiang
 * @date 2021/5/14 10:07
 */
@Data
@Accessors(chain = true)
public class AssetsLogRequest {

    /**
     * 分表锚定日期
     */
    private Date submeterDate;
    /**
     * 分表跨月数量
     */
    private Integer submeterMonths;

    /**
     * appid
     */
    private String appId;

    /**
     * 变现猫用户ID
     */
    private String uid;

    /**
     * 资产类型
     */
    private String assetType;

    /**
     * 操作类型,1:增加,2:扣除
     */
    private Integer operateType;

    /**
     * 操作状态,1:成功,2:失败
     */
    private Integer operateStatus;

    /**
     * 接口调用状态,1:正常,2:错误,3:超时
     */
    private Integer apiStatus;

    /**
     * 记录时间（x >= createTimeStart）
     */
    private Date createTimeStart;

    /**
     * 记录时间（x < createTimeStart）
     */
    private Date createTimeEnd;
}
