package com.bxm.game.common.dal.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.bxm.game.common.dal.entity.AssetsLogYmd;

/**
 * 货币流水记录（日分表，大数据使用）<br/>
 *
 * @author kerry.jiang
 * @date 2021/5/17 10:03
 */
public interface IAssetsLogYmdService extends IService<AssetsLogYmd> {

    /**
     * 数据表是否存在<br/>
     *
     * @param databaseName 数据库名
     * @param tableName 数据表名
     * @return
     */
    boolean existTable(String databaseName, String tableName);

    /**
     * 数据库不存在，则创建表<br/>
     *
     * @param databaseName 数据库名
     * @param tableName 数据表名
     */
    void createTableIfNecessary(String databaseName, String tableName);
}
