package com.bxm.game.common.dal.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bxm.game.common.dal.service.IAcquiredPropLogService;
import com.bxm.game.common.dal.entity.AcquiredPropLog;
import com.bxm.game.common.dal.mapper.AcquiredPropLogMapper;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author Allen Hu
 * @since 2020-12-15
 */
public class AcquiredPropLogServiceImpl extends ServiceImpl<AcquiredPropLogMapper, AcquiredPropLog> implements IAcquiredPropLogService {

    @Override
    public boolean isExists(String databaseName, String tableName) {
        return getBaseMapper().checkTableExists(databaseName, tableName) > 0;
    }

    @Override
    public void createTable(String tableName) {
        getBaseMapper().createTable(tableName);
    }

    @Override
    public void createTableIfNecessary(String databaseName, String tableName) {
        if (!isExists(databaseName, tableName)) {
            createTable(tableName);
        }
    }
}
