package com.bxm.game.common.dal.service.impl;

import java.util.*;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bxm.game.common.dal.entity.AssetsLog;
import com.bxm.game.common.dal.mapper.AssetsLogMapper;
import com.bxm.game.common.dal.model.AssetsLogRequest;
import com.bxm.game.common.dal.service.IAssetsLogService;
import com.bxm.warcar.utils.DateHelper;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author Allen Hu
 * @since 2021-01-12
 */
public class AssetsLogServiceImpl extends ServiceImpl<AssetsLogMapper, AssetsLog> implements IAssetsLogService {

    @Override
    public boolean existTable(String databaseName, String tableName) {
        return getBaseMapper().existTable(databaseName, tableName) > 0;
    }

    @Override
    public void createTableIfNecessary(String databaseName, String tableName) {
        if (!existTable(databaseName, tableName)) {
            getBaseMapper().createTable(tableName);
        }
    }

    @Override
    public Page<AssetsLog> pageByUid(String databaseName, Page page, AssetsLogRequest request) {
        if(request.getAppId() == null){
            return new Page<>(page.getCurrent(), page.getSize());
        }

        List<String> tableNames = filterTableNames(databaseName,
                getMonthDateList(request.getSubmeterDate(), request.getSubmeterMonths()));
        if(CollectionUtils.isEmpty(tableNames)){
            return new Page<>(page.getCurrent(), page.getSize());
        }
        return getBaseMapper().pageByUid(page, tableNames, request);
    }

    /**
     * 获取最近几月的日期列表<br/>
     */
    private List<String> getMonthDateList(Date day, int months) {
        List<String> list = new ArrayList<>();
        if (months == 0) {
            return list;
        }

        Calendar cal = new GregorianCalendar();
        cal.setTime(day);
        cal.set(Calendar.DAY_OF_MONTH, 1);

        list.add(DateHelper.format(cal.getTime(),
                AssetsLog.TABLE_SUFFIX_FORMAT));
        if (months > 0) {
            for (int i = 1; i < months; i++) {
                cal.add(Calendar.MONTH, 1);
                list.add(DateHelper.format(cal.getTime(),
                        AssetsLog.TABLE_SUFFIX_FORMAT));
            }
        } else {
            for (int i = -1; i > months; i--) {
                cal.add(Calendar.MONTH, -1);
                list.add(DateHelper.format(cal.getTime(),
                        AssetsLog.TABLE_SUFFIX_FORMAT));
            }
        }
        return list;
    }

    /**
     * 过滤不存在的分表<br/>
     */
    private List<String> filterTableNames(String databaseName, List<String> ymList){
        List<String> list = new ArrayList<>();
        for (String ym : ymList) {
            String tableName = StringUtils.join(AssetsLog.TABLE_PREFIX, ym);
            boolean exists = AssetsLog.TABLE_LIST.contains(tableName);
            if(!exists){//不存在
                exists = getBaseMapper().existTable(databaseName, tableName) > 0;
                if(exists){
                    list.add(tableName);
                    //缓存已存在的表名
                    AssetsLog.TABLE_LIST.add(tableName);
                }
            }else{
                list.add(tableName);
            }
        }
        return list;
    }
}
