package com.bxm.game.common.dal.entity;

import com.bxm.game.common.dal.BaseEntity;
import java.time.LocalDateTime;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 用户每日指标
 * </p>
 *
 * @author Allen Hu
 * @since 2021-08-30
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class KpiUserDaily extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 日期
     */
    private String rptDate;

    /**
     * 活动类型
     */
    private String activityType;

    /**
     * appid
     */
    private String appId;

    /**
     * 变现猫用户ID
     */
    private String uid;

    /**
     * 指标代码
     */
    private String kpiCode;

    /**
     * 指标值
     */
    private String kpiValue;

    /**
     * 同步时间
     */
    private LocalDateTime createTime;


    public static final String RPT_DATE = "rpt_date";

    public static final String ACTIVITY_TYPE = "activity_type";

    public static final String APP_ID = "app_id";

    public static final String UID = "uid";

    public static final String KPI_CODE = "kpi_code";

    public static final String KPI_VALUE = "kpi_value";

    public static final String CREATE_TIME = "create_time";

}
