/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.mcat.common;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;
import redis.clients.jedis.JedisPoolConfig;

@ConfigurationProperties(prefix="mcat")
public class McatProperties {
    private int ecpm = 100;
    private int percentOfEcpm = 5;
    private int maximumPlayVideoPerUserOfDaily = 5;
    private int maximumMembersOnceOnGrantRemovalScheduler = 1000;
    private float shamBonusMultiply = 11.0f;
    private float shamAttenderMultiply = 1.0f;
    private int onlineTimeoutOfMinutes = 5;
    @Deprecated
    private Mq mq = new Mq();
    private PropConfig prop = new PropConfig();
    private SspJedisConfiguration ssp = new SspJedisConfiguration();
    private List<String> tips = Lists.newArrayList((Object[])new String[]{"\u4e0d\u540c\u5956\u7b7e\u53ef\u4e2d\u5f97\u7684\u5956\u91d1\u500d\u6570\u4e0d\u540c", "\u94bb\u77f3\u7b7e\u6700\u4f4e\u53ef\u4e2d\u5f972\u500d\u5956\u91d1", "\u5728\u5176\u4ed6\u5e94\u7528\u5185\u627e\u5230\u53d8\u73b0\u732b\u53ef\u79ef\u6512\u66f4\u591a\u5956\u7b7e", "\u79ef\u6512\u7684\u5956\u7b7e\u8d8a\u591a\u4e2d\u5956\u7387\u8d8a\u9ad8", "\u6bcf\u59298\u70b9\u5f00\u5956 12\u70b9\u524d\u9886\u5956", "\u5956\u7b7e\u7684\u5956\u91d1\u4f1a\u6839\u636e\u7528\u6237\u4ea7\u51fa\u4ef7\u503c\u800c\u6ce2\u52a8", "\u63d0\u73b0\u95e8\u69db\u6700\u4f4e\u4e3a0.3\u5143", "\u5173\u6ce8\u53d8\u73b0\u732b\u5fae\u4fe1\u516c\u4f17\u53f7\u67e5\u770b\u66f4\u591a\u653b\u7565", "\u4e2d\u5956\u672a\u9886\u53d6 \u89c6\u4e3a\u653e\u5f03\u8d44\u683c", "\u5956\u7b7e\u53c2\u4e0e\u62bd\u5b9e\u7269\u6d3b\u52a8\u8fd1\u671f\u4e0a\u7ebf"});
    private List<String> comfort = Lists.newArrayList((Object[])new String[]{"\u51d1\u51d1\u624b\uff0c\u597d\u8fd0\u6c14\u660e\u65e5\u6765", "\u79ef\u6512\u66f4\u591a\u5956\u7b7e\u53ef\u63d0\u9ad8\u4e2d\u5956\u6982\u7387", "\u5173\u6ce8\u53d8\u73b0\u732b\u5fae\u4fe1\u516c\u4f17\u53f7\u67e5\u770b\u66f4\u591a\u653b\u7565"});

    public BigDecimal getOnceMoney() {
        return BigDecimal.valueOf(this.ecpm).divide(BigDecimal.valueOf(1000L), 3, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(this.percentOfEcpm)).multiply(BigDecimal.valueOf(this.shamBonusMultiply)).divide(BigDecimal.valueOf(100L), 3, RoundingMode.HALF_UP).movePointRight(3);
    }

    public int getEcpm() {
        return this.ecpm;
    }

    public int getPercentOfEcpm() {
        return this.percentOfEcpm;
    }

    public int getMaximumPlayVideoPerUserOfDaily() {
        return this.maximumPlayVideoPerUserOfDaily;
    }

    public int getMaximumMembersOnceOnGrantRemovalScheduler() {
        return this.maximumMembersOnceOnGrantRemovalScheduler;
    }

    public float getShamBonusMultiply() {
        return this.shamBonusMultiply;
    }

    public float getShamAttenderMultiply() {
        return this.shamAttenderMultiply;
    }

    public int getOnlineTimeoutOfMinutes() {
        return this.onlineTimeoutOfMinutes;
    }

    @Deprecated
    public Mq getMq() {
        return this.mq;
    }

    public PropConfig getProp() {
        return this.prop;
    }

    public SspJedisConfiguration getSsp() {
        return this.ssp;
    }

    public List<String> getTips() {
        return this.tips;
    }

    public List<String> getComfort() {
        return this.comfort;
    }

    public void setEcpm(int ecpm) {
        this.ecpm = ecpm;
    }

    public void setPercentOfEcpm(int percentOfEcpm) {
        this.percentOfEcpm = percentOfEcpm;
    }

    public void setMaximumPlayVideoPerUserOfDaily(int maximumPlayVideoPerUserOfDaily) {
        this.maximumPlayVideoPerUserOfDaily = maximumPlayVideoPerUserOfDaily;
    }

    public void setMaximumMembersOnceOnGrantRemovalScheduler(int maximumMembersOnceOnGrantRemovalScheduler) {
        this.maximumMembersOnceOnGrantRemovalScheduler = maximumMembersOnceOnGrantRemovalScheduler;
    }

    public void setShamBonusMultiply(float shamBonusMultiply) {
        this.shamBonusMultiply = shamBonusMultiply;
    }

    public void setShamAttenderMultiply(float shamAttenderMultiply) {
        this.shamAttenderMultiply = shamAttenderMultiply;
    }

    public void setOnlineTimeoutOfMinutes(int onlineTimeoutOfMinutes) {
        this.onlineTimeoutOfMinutes = onlineTimeoutOfMinutes;
    }

    @Deprecated
    public void setMq(Mq mq) {
        this.mq = mq;
    }

    public void setProp(PropConfig prop) {
        this.prop = prop;
    }

    public void setSsp(SspJedisConfiguration ssp) {
        this.ssp = ssp;
    }

    public void setTips(List<String> tips) {
        this.tips = tips;
    }

    public void setComfort(List<String> comfort) {
        this.comfort = comfort;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof McatProperties)) {
            return false;
        }
        McatProperties other = (McatProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEcpm() != other.getEcpm()) {
            return false;
        }
        if (this.getPercentOfEcpm() != other.getPercentOfEcpm()) {
            return false;
        }
        if (this.getMaximumPlayVideoPerUserOfDaily() != other.getMaximumPlayVideoPerUserOfDaily()) {
            return false;
        }
        if (this.getMaximumMembersOnceOnGrantRemovalScheduler() != other.getMaximumMembersOnceOnGrantRemovalScheduler()) {
            return false;
        }
        if (Float.compare(this.getShamBonusMultiply(), other.getShamBonusMultiply()) != 0) {
            return false;
        }
        if (Float.compare(this.getShamAttenderMultiply(), other.getShamAttenderMultiply()) != 0) {
            return false;
        }
        if (this.getOnlineTimeoutOfMinutes() != other.getOnlineTimeoutOfMinutes()) {
            return false;
        }
        Mq this$mq = this.getMq();
        Mq other$mq = other.getMq();
        if (this$mq == null ? other$mq != null : !((Object)this$mq).equals(other$mq)) {
            return false;
        }
        PropConfig this$prop = this.getProp();
        PropConfig other$prop = other.getProp();
        if (this$prop == null ? other$prop != null : !((Object)this$prop).equals(other$prop)) {
            return false;
        }
        SspJedisConfiguration this$ssp = this.getSsp();
        SspJedisConfiguration other$ssp = other.getSsp();
        if (this$ssp == null ? other$ssp != null : !((Object)((Object)this$ssp)).equals((Object)other$ssp)) {
            return false;
        }
        List<String> this$tips = this.getTips();
        List<String> other$tips = other.getTips();
        if (this$tips == null ? other$tips != null : !((Object)this$tips).equals(other$tips)) {
            return false;
        }
        List<String> this$comfort = this.getComfort();
        List<String> other$comfort = other.getComfort();
        return !(this$comfort == null ? other$comfort != null : !((Object)this$comfort).equals(other$comfort));
    }

    protected boolean canEqual(Object other) {
        return other instanceof McatProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEcpm();
        result = result * 59 + this.getPercentOfEcpm();
        result = result * 59 + this.getMaximumPlayVideoPerUserOfDaily();
        result = result * 59 + this.getMaximumMembersOnceOnGrantRemovalScheduler();
        result = result * 59 + Float.floatToIntBits(this.getShamBonusMultiply());
        result = result * 59 + Float.floatToIntBits(this.getShamAttenderMultiply());
        result = result * 59 + this.getOnlineTimeoutOfMinutes();
        Mq $mq = this.getMq();
        result = result * 59 + ($mq == null ? 43 : ((Object)$mq).hashCode());
        PropConfig $prop = this.getProp();
        result = result * 59 + ($prop == null ? 43 : ((Object)$prop).hashCode());
        SspJedisConfiguration $ssp = this.getSsp();
        result = result * 59 + ($ssp == null ? 43 : ((Object)((Object)$ssp)).hashCode());
        List<String> $tips = this.getTips();
        result = result * 59 + ($tips == null ? 43 : ((Object)$tips).hashCode());
        List<String> $comfort = this.getComfort();
        result = result * 59 + ($comfort == null ? 43 : ((Object)$comfort).hashCode());
        return result;
    }

    public String toString() {
        return "McatProperties(ecpm=" + this.getEcpm() + ", percentOfEcpm=" + this.getPercentOfEcpm() + ", maximumPlayVideoPerUserOfDaily=" + this.getMaximumPlayVideoPerUserOfDaily() + ", maximumMembersOnceOnGrantRemovalScheduler=" + this.getMaximumMembersOnceOnGrantRemovalScheduler() + ", shamBonusMultiply=" + this.getShamBonusMultiply() + ", shamAttenderMultiply=" + this.getShamAttenderMultiply() + ", onlineTimeoutOfMinutes=" + this.getOnlineTimeoutOfMinutes() + ", mq=" + this.getMq() + ", prop=" + this.getProp() + ", ssp=" + (Object)((Object)this.getSsp()) + ", tips=" + this.getTips() + ", comfort=" + this.getComfort() + ")";
    }

    public static class SspJedisConfiguration
    extends JedisPoolConfig {
        private String host = "localhost";
        private String password;
        private int port = 6379;
        private int timeout = 2000;
        private int database = 0;

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public int getTimeout() {
            return this.timeout;
        }

        public void setTimeout(int timeout) {
            this.timeout = timeout;
        }

        public int getDatabase() {
            return this.database;
        }

        public void setDatabase(int database) {
            this.database = database;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SspJedisConfiguration)) {
                return false;
            }
            SspJedisConfiguration other = (SspJedisConfiguration)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (this.getPort() != other.getPort()) {
                return false;
            }
            if (this.getTimeout() != other.getTimeout()) {
                return false;
            }
            if (this.getDatabase() != other.getDatabase()) {
                return false;
            }
            String this$host = this.getHost();
            String other$host = other.getHost();
            if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            return !(this$password == null ? other$password != null : !this$password.equals(other$password));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SspJedisConfiguration;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPort();
            result = result * 59 + this.getTimeout();
            result = result * 59 + this.getDatabase();
            String $host = this.getHost();
            result = result * 59 + ($host == null ? 43 : $host.hashCode());
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            return result;
        }

        public String toString() {
            return "McatProperties.SspJedisConfiguration(host=" + this.getHost() + ", password=" + this.getPassword() + ", port=" + this.getPort() + ", timeout=" + this.getTimeout() + ", database=" + this.getDatabase() + ")";
        }
    }

    public static class PropConfig {
        private int ratioHitBronze = 60;
        private int ratioHitSilver = 20;
        private int ratioHitGold = 15;
        private int ratioHitDiamond = 5;
        private int ratioWinBronze = 69;
        private int ratioWinSilver = 30;
        private int ratioWinGold = 14;
        private int ratioWinDiamond = 8;
        private float multipleMoneyBronze = 1.0f;
        private float multipleMoneySilver = 1.1f;
        private float multipleMoneyGold = 1.3f;
        private float multipleMoneyDiamond = 2.0f;

        public int getRatioHitBronze() {
            return this.ratioHitBronze;
        }

        public int getRatioHitSilver() {
            return this.ratioHitSilver;
        }

        public int getRatioHitGold() {
            return this.ratioHitGold;
        }

        public int getRatioHitDiamond() {
            return this.ratioHitDiamond;
        }

        public int getRatioWinBronze() {
            return this.ratioWinBronze;
        }

        public int getRatioWinSilver() {
            return this.ratioWinSilver;
        }

        public int getRatioWinGold() {
            return this.ratioWinGold;
        }

        public int getRatioWinDiamond() {
            return this.ratioWinDiamond;
        }

        public float getMultipleMoneyBronze() {
            return this.multipleMoneyBronze;
        }

        public float getMultipleMoneySilver() {
            return this.multipleMoneySilver;
        }

        public float getMultipleMoneyGold() {
            return this.multipleMoneyGold;
        }

        public float getMultipleMoneyDiamond() {
            return this.multipleMoneyDiamond;
        }

        public void setRatioHitBronze(int ratioHitBronze) {
            this.ratioHitBronze = ratioHitBronze;
        }

        public void setRatioHitSilver(int ratioHitSilver) {
            this.ratioHitSilver = ratioHitSilver;
        }

        public void setRatioHitGold(int ratioHitGold) {
            this.ratioHitGold = ratioHitGold;
        }

        public void setRatioHitDiamond(int ratioHitDiamond) {
            this.ratioHitDiamond = ratioHitDiamond;
        }

        public void setRatioWinBronze(int ratioWinBronze) {
            this.ratioWinBronze = ratioWinBronze;
        }

        public void setRatioWinSilver(int ratioWinSilver) {
            this.ratioWinSilver = ratioWinSilver;
        }

        public void setRatioWinGold(int ratioWinGold) {
            this.ratioWinGold = ratioWinGold;
        }

        public void setRatioWinDiamond(int ratioWinDiamond) {
            this.ratioWinDiamond = ratioWinDiamond;
        }

        public void setMultipleMoneyBronze(float multipleMoneyBronze) {
            this.multipleMoneyBronze = multipleMoneyBronze;
        }

        public void setMultipleMoneySilver(float multipleMoneySilver) {
            this.multipleMoneySilver = multipleMoneySilver;
        }

        public void setMultipleMoneyGold(float multipleMoneyGold) {
            this.multipleMoneyGold = multipleMoneyGold;
        }

        public void setMultipleMoneyDiamond(float multipleMoneyDiamond) {
            this.multipleMoneyDiamond = multipleMoneyDiamond;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PropConfig)) {
                return false;
            }
            PropConfig other = (PropConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getRatioHitBronze() != other.getRatioHitBronze()) {
                return false;
            }
            if (this.getRatioHitSilver() != other.getRatioHitSilver()) {
                return false;
            }
            if (this.getRatioHitGold() != other.getRatioHitGold()) {
                return false;
            }
            if (this.getRatioHitDiamond() != other.getRatioHitDiamond()) {
                return false;
            }
            if (this.getRatioWinBronze() != other.getRatioWinBronze()) {
                return false;
            }
            if (this.getRatioWinSilver() != other.getRatioWinSilver()) {
                return false;
            }
            if (this.getRatioWinGold() != other.getRatioWinGold()) {
                return false;
            }
            if (this.getRatioWinDiamond() != other.getRatioWinDiamond()) {
                return false;
            }
            if (Float.compare(this.getMultipleMoneyBronze(), other.getMultipleMoneyBronze()) != 0) {
                return false;
            }
            if (Float.compare(this.getMultipleMoneySilver(), other.getMultipleMoneySilver()) != 0) {
                return false;
            }
            if (Float.compare(this.getMultipleMoneyGold(), other.getMultipleMoneyGold()) != 0) {
                return false;
            }
            return Float.compare(this.getMultipleMoneyDiamond(), other.getMultipleMoneyDiamond()) == 0;
        }

        protected boolean canEqual(Object other) {
            return other instanceof PropConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getRatioHitBronze();
            result = result * 59 + this.getRatioHitSilver();
            result = result * 59 + this.getRatioHitGold();
            result = result * 59 + this.getRatioHitDiamond();
            result = result * 59 + this.getRatioWinBronze();
            result = result * 59 + this.getRatioWinSilver();
            result = result * 59 + this.getRatioWinGold();
            result = result * 59 + this.getRatioWinDiamond();
            result = result * 59 + Float.floatToIntBits(this.getMultipleMoneyBronze());
            result = result * 59 + Float.floatToIntBits(this.getMultipleMoneySilver());
            result = result * 59 + Float.floatToIntBits(this.getMultipleMoneyGold());
            result = result * 59 + Float.floatToIntBits(this.getMultipleMoneyDiamond());
            return result;
        }

        public String toString() {
            return "McatProperties.PropConfig(ratioHitBronze=" + this.getRatioHitBronze() + ", ratioHitSilver=" + this.getRatioHitSilver() + ", ratioHitGold=" + this.getRatioHitGold() + ", ratioHitDiamond=" + this.getRatioHitDiamond() + ", ratioWinBronze=" + this.getRatioWinBronze() + ", ratioWinSilver=" + this.getRatioWinSilver() + ", ratioWinGold=" + this.getRatioWinGold() + ", ratioWinDiamond=" + this.getRatioWinDiamond() + ", multipleMoneyBronze=" + this.getMultipleMoneyBronze() + ", multipleMoneySilver=" + this.getMultipleMoneySilver() + ", multipleMoneyGold=" + this.getMultipleMoneyGold() + ", multipleMoneyDiamond=" + this.getMultipleMoneyDiamond() + ")";
        }
    }

    public static class Mq {
        private String acquiredTopic = "acquired";
        private String acquiredConsumerId = "mcat";
        private int cacheQueueSize = 20000;

        public String getAcquiredTopic() {
            return this.acquiredTopic;
        }

        public String getAcquiredConsumerId() {
            return this.acquiredConsumerId;
        }

        public int getCacheQueueSize() {
            return this.cacheQueueSize;
        }

        public void setAcquiredTopic(String acquiredTopic) {
            this.acquiredTopic = acquiredTopic;
        }

        public void setAcquiredConsumerId(String acquiredConsumerId) {
            this.acquiredConsumerId = acquiredConsumerId;
        }

        public void setCacheQueueSize(int cacheQueueSize) {
            this.cacheQueueSize = cacheQueueSize;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Mq)) {
                return false;
            }
            Mq other = (Mq)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getCacheQueueSize() != other.getCacheQueueSize()) {
                return false;
            }
            String this$acquiredTopic = this.getAcquiredTopic();
            String other$acquiredTopic = other.getAcquiredTopic();
            if (this$acquiredTopic == null ? other$acquiredTopic != null : !this$acquiredTopic.equals(other$acquiredTopic)) {
                return false;
            }
            String this$acquiredConsumerId = this.getAcquiredConsumerId();
            String other$acquiredConsumerId = other.getAcquiredConsumerId();
            return !(this$acquiredConsumerId == null ? other$acquiredConsumerId != null : !this$acquiredConsumerId.equals(other$acquiredConsumerId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Mq;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getCacheQueueSize();
            String $acquiredTopic = this.getAcquiredTopic();
            result = result * 59 + ($acquiredTopic == null ? 43 : $acquiredTopic.hashCode());
            String $acquiredConsumerId = this.getAcquiredConsumerId();
            result = result * 59 + ($acquiredConsumerId == null ? 43 : $acquiredConsumerId.hashCode());
            return result;
        }

        public String toString() {
            return "McatProperties.Mq(acquiredTopic=" + this.getAcquiredTopic() + ", acquiredConsumerId=" + this.getAcquiredConsumerId() + ", cacheQueueSize=" + this.getCacheQueueSize() + ")";
        }
    }
}

