/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.mcat.common.scene.video;

import com.bxm.game.common.core.AppContext;
import com.bxm.game.common.core.archives.CustomArchiveHandler;
import com.bxm.game.common.core.prop.Prop;
import com.bxm.game.common.core.scene.AbstractMaximumTimesOnDailySceneService;
import com.bxm.game.common.core.scene.SceneRequest;
import com.bxm.game.mcat.common.Constants;
import com.bxm.game.mcat.common.McatProperties;
import com.bxm.game.mcat.common.prop.BronzeProp;
import com.bxm.game.mcat.common.prop.DiamondProp;
import com.bxm.game.mcat.common.prop.GoldProp;
import com.bxm.game.mcat.common.prop.SilverProp;
import com.bxm.game.mcat.common.scene.video.PlayVideoSceneRequest;
import com.bxm.game.mcat.common.scene.video.PlayVideoSceneResponse;
import com.bxm.game.mcat.common.scene.video.archive.PlayVideoCustomArchiveHandler;
import com.bxm.game.mcat.common.ticket.statistics.StatisticsService;
import com.bxm.game.mcat.common.ticket.winner.WinnerService;
import java.math.BigDecimal;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.springframework.stereotype.Service;

@Service
public class PlayVideoSceneServiceImpl
extends AbstractMaximumTimesOnDailySceneService<PlayVideoSceneRequest, PlayVideoSceneResponse> {
    private final McatProperties properties;
    private final PlayVideoCustomArchiveHandler handler;
    private final StatisticsService statisticsService;
    private final WinnerService winnerService;

    public PlayVideoSceneServiceImpl(McatProperties properties, PlayVideoCustomArchiveHandler handler, StatisticsService statisticsService, WinnerService winnerService) {
        this.properties = properties;
        this.handler = handler;
        this.statisticsService = statisticsService;
        this.winnerService = winnerService;
    }

    protected String createId(PlayVideoSceneRequest request) {
        String id = super.createId((SceneRequest)request);
        if (Constants.isTestAppId(AppContext.get().getAppId())) {
            return "T" + StringUtils.substring((String)id, (int)1);
        }
        return id;
    }

    public CustomArchiveHandler getCustomArchiveHandler() {
        return this.handler;
    }

    protected int getMaximum() {
        return this.properties.getMaximumPlayVideoPerUserOfDaily();
    }

    protected Prop takeProp(PlayVideoSceneRequest request, Map<Object, Object> attach) {
        McatProperties.PropConfig propConfig = this.properties.getProp();
        int r = RandomUtils.nextInt((int)0, (int)100);
        if (r < propConfig.getRatioHitDiamond()) {
            return new DiamondProp();
        }
        if (r < propConfig.getRatioHitGold()) {
            return new GoldProp();
        }
        if (r < propConfig.getRatioHitSilver()) {
            return new SilverProp();
        }
        return new BronzeProp();
    }

    protected PlayVideoSceneResponse createResponse(PlayVideoSceneRequest request, String id, Prop prop, Map<Object, Object> attach) {
        BigDecimal money = this.statisticsService.getOnceMoneyOfToday();
        long m = this.winnerService.computeMoney(money.longValue(), prop.getAssetType());
        PlayVideoSceneResponse response = new PlayVideoSceneResponse();
        response.setMoney(m <= 0L ? this.properties.getOnceMoney().longValue() : m);
        return response;
    }

    public String getSceneType() {
        return "play_video";
    }

    public Class<PlayVideoSceneRequest> getRequestClass() {
        return PlayVideoSceneRequest.class;
    }
}

