/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.mcat.common.session;

import com.bxm.game.mcat.common.McatKey;
import com.bxm.game.mcat.common.session.OnlineService;
import com.bxm.game.mcat.common.user.UserService;
import com.bxm.warcar.cache.Fetcher;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service
public class RedisOnlineServiceImpl
implements OnlineService {
    private final UserService userService;
    private final McatKey mcatKey;
    private final Fetcher fetcher;

    public RedisOnlineServiceImpl(UserService userService, McatKey mcatKey, Fetcher fetcher) {
        this.userService = userService;
        this.mcatKey = mcatKey;
        this.fetcher = fetcher;
    }

    @Override
    public void online(String uid) {
        long userId = this.userService.getUserId(uid);
        JedisPool jedisPool = this.getJedisPool();
        try (Jedis jedis = jedisPool.getResource();){
            jedis.setbit(this.mcatKey.bitOnline().generateKey(), userId, true);
        }
    }

    @Override
    public void offline(String uid) {
        long userId = this.userService.getUserId(uid);
        JedisPool jedisPool = this.getJedisPool();
        try (Jedis jedis = jedisPool.getResource();){
            jedis.setbit(this.mcatKey.bitOnline().generateKey(), userId, false);
        }
    }

    @Override
    public long online() {
        JedisPool jedisPool = this.getJedisPool();
        try (Jedis jedis = jedisPool.getResource();){
            long l = jedis.bitcount(this.mcatKey.bitOnline().generateKey());
            return l;
        }
    }

    private JedisPool getJedisPool() {
        Object clientOriginal = this.fetcher.getClientOriginal();
        if (!(clientOriginal instanceof JedisPool)) {
            throw new RuntimeException("clientOriginal is not JedisPool!");
        }
        return (JedisPool)clientOriginal;
    }
}

