/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.mcat.common.ticket.listener;

import com.bxm.game.common.core.AppContext;
import com.bxm.game.common.core.scene.AcquiringOrMultiplyPropEvent;
import com.bxm.game.mcat.common.McatProperties;
import com.bxm.game.mcat.common.ticket.listener.QueueMessage;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.mq.Message;
import com.bxm.warcar.mq.Producer;
import com.bxm.warcar.mq.SendException;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.NamedThreadFactory;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

@Deprecated
public class SendMessageEventListener
implements EventListener<AcquiringOrMultiplyPropEvent>,
InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(SendMessageEventListener.class);
    private final McatProperties properties;
    private final Producer producer;
    private final LinkedBlockingQueue<QueueMessage> failQueue;
    private final ThreadPoolExecutor repeat;
    private final AtomicBoolean shutdown = new AtomicBoolean(false);

    public SendMessageEventListener(McatProperties properties, Producer producer) {
        this.properties = properties;
        this.producer = producer;
        this.failQueue = new LinkedBlockingQueue(properties.getMq().getCacheQueueSize());
        this.repeat = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("repeat"));
    }

    public void afterPropertiesSet() {
        this.repeat.execute(this::consumeQueue);
    }

    public void destroy() {
        this.shutdown.compareAndSet(false, true);
        ArrayList dest = Lists.newArrayList();
        this.failQueue.drainTo(dest);
        for (QueueMessage queueMessage : dest) {
            this.sendMessage(queueMessage);
        }
        this.repeat.shutdown();
        try {
            if (!this.repeat.awaitTermination(2L, TimeUnit.SECONDS)) {
                log.warn("awaitTermination timeOut!");
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Subscribe
    public void consume(AcquiringOrMultiplyPropEvent event) {
        QueueMessage queueMessage = QueueMessage.builder().appId(AppContext.get().getAppId()).uid(AppContext.get().getUid()).device(AppContext.get().getDevice()).sceneRequest(event.getRequest()).sceneResponse(event.getResponse()).build();
        this.sendMessage(queueMessage);
    }

    private void sendMessage(QueueMessage message) {
        try {
            this.producer.send(new Message(this.properties.getMq().getAcquiredTopic(), JsonHelper.convert2bytes((Object)message)));
        }
        catch (SendException e) {
            log.error("send: ", (Throwable)e);
            if (this.shutdown.get()) {
                this.writeMessageToFile(message);
                return;
            }
            while (!this.failQueue.offer(message)) {
                QueueMessage take = null;
                try {
                    take = this.failQueue.take();
                }
                catch (InterruptedException ex) {
                    this.writeMessageToFile(take);
                }
            }
        }
    }

    private void writeMessageToFile(QueueMessage take) {
        log.warn("=:=:={}", (Object)JsonHelper.convert((Object)take));
    }

    private void consumeQueue() {
        while (!this.shutdown.get()) {
            try {
                QueueMessage take = this.failQueue.poll(1L, TimeUnit.SECONDS);
                if (!Objects.nonNull(take)) continue;
                this.sendMessage(take);
            }
            catch (InterruptedException e) {
                log.warn("take: ", (Throwable)e);
            }
        }
    }
}

