/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.mcat.common.ticket.statistics;

import com.bxm.game.mcat.common.McatKey;
import com.bxm.game.mcat.common.McatProperties;
import com.bxm.game.mcat.common.prop.AssetType;
import com.bxm.game.mcat.common.ticket.statistics.MutableStatisticsService;
import com.bxm.game.mcat.common.user.UserService;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.TypeHelper;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;

@Service
public class RedisMutableStatisticsServiceImpl
implements MutableStatisticsService {
    private static final Logger log = LoggerFactory.getLogger(RedisMutableStatisticsServiceImpl.class);
    private final McatProperties properties;
    private final McatKey mcatKey;
    @Autowired
    private Fetcher fetcher;
    @Autowired
    private UserService userService;

    public RedisMutableStatisticsServiceImpl(McatProperties properties, McatKey mcatKey) {
        this.properties = properties;
        this.mcatKey = mcatKey;
    }

    @Override
    public long incrementAttender(String uid) {
        JedisPool jedisPool = this.getJedisPool();
        try (Jedis jedis = jedisPool.getResource();){
            long userId = this.userService.getUserId(uid);
            String key = this.mcatKey.bitmapAttendedOfToday().generateKey();
            jedis.setbit(key, userId, true);
            long l = -1L;
            return l;
        }
    }

    @Override
    public long getAttenders() {
        JedisPool jedisPool = this.getJedisPool();
        try (Jedis jedis = jedisPool.getResource();){
            String key = this.mcatKey.bitmapAttendedOfToday().generateKey();
            jedis.expire(key, 604800);
            long l = jedis.bitcount(key);
            return l;
        }
    }

    @Override
    public void addTicket(String assetType, String id) {
        JedisPool jedisPool = this.getJedisPool();
        try (Jedis jedis = jedisPool.getResource();){
            String key = this.mcatKey.setForTicketOfToday(assetType, id).generateKey();
            jedis.sadd(key, new String[]{id});
            jedis.expire(key, 172800);
        }
    }

    @Override
    public long computeCountTicketOnYesterday(String assetType) {
        JedisPool jedisPool = this.getJedisPool();
        try (Jedis jedis = jedisPool.getResource();){
            Pipeline pipelined = jedis.pipelined();
            for (int i = 0; i < 1000; ++i) {
                KeyGenerator key = this.mcatKey.setForTicketOfYesterday(assetType, i);
                pipelined.scard(key.generateKey());
            }
            List returnAll = pipelined.syncAndReturnAll();
            long count = 0L;
            for (Object o : returnAll) {
                count += TypeHelper.castToLong(o).longValue();
            }
            long l = count;
            return l;
        }
    }

    @Override
    public long countTicketOnToday() {
        String[] all = AssetType.ALL;
        long count = 0L;
        for (String assetType : all) {
            count += this.countTicketOnToday(assetType);
        }
        return count;
    }

    @Override
    public long countTicketOnToday(String assetType) {
        JedisPool jedisPool = this.getJedisPool();
        try (Jedis jedis = jedisPool.getResource();){
            Pipeline pipelined = jedis.pipelined();
            for (int i = 0; i < 1000; ++i) {
                KeyGenerator key = this.mcatKey.setForTicketOfToday(assetType, i);
                pipelined.scard(key.generateKey());
            }
            List returnAll = pipelined.syncAndReturnAll();
            long count = 0L;
            for (Object o : returnAll) {
                count += TypeHelper.castToLong(o).longValue();
            }
            long l = count;
            return l;
        }
    }

    @Override
    public long countTicketWithoutToday() {
        String[] all = AssetType.ALL;
        long count = 0L;
        for (String assetType : all) {
            count += this.countTicketWithoutToday(assetType);
        }
        return count;
    }

    @Override
    public long countTicketWithoutToday(String assetType) {
        JedisPool jedisPool = this.getJedisPool();
        try (Jedis jedis = jedisPool.getResource();){
            Pipeline pipelined = jedis.pipelined();
            for (int i = 0; i < 1000; ++i) {
                KeyGenerator key = this.mcatKey.setForTicketWithoutToday(assetType, i);
                pipelined.scard(key.generateKey());
            }
            List returnAll = pipelined.syncAndReturnAll();
            long count = 0L;
            for (Object o : returnAll) {
                count += TypeHelper.castToLong(o).longValue();
            }
            long l = count;
            return l;
        }
    }

    @Override
    public void consumeTicketOnYesterday(String assetType, Consumer<Collection<String>> consumer) {
        JedisPool jedisPool = this.getJedisPool();
        try (Jedis jedis = jedisPool.getResource();){
            for (int i = 0; i < 1000; ++i) {
                KeyGenerator key = this.mcatKey.setForTicketOfYesterday(assetType, i);
                this.sscanToConsume(consumer, jedis, key);
            }
        }
    }

    @Override
    public void consumeTicketWithoutToday(String assetType, Consumer<Collection<String>> consumer) {
        JedisPool jedisPool = this.getJedisPool();
        try (Jedis jedis = jedisPool.getResource();){
            for (int i = 0; i < 1000; ++i) {
                KeyGenerator key = this.mcatKey.setForTicketWithoutToday(assetType, i);
                this.sscanToConsume(consumer, jedis, key);
            }
        }
    }

    @Override
    public void removeTestTicketWithoutToday(String assetType) {
        JedisPool jedisPool = this.getJedisPool();
        try (final Jedis jedis = jedisPool.getResource();){
            log.info("\u5f00\u59cb\u5220\u9664 {} \u7c7b\u578b\u7684\u6d4b\u8bd5\u5956\u7b7e", (Object)assetType);
            final AtomicLong deleted = new AtomicLong(0L);
            for (int i = 0; i < 1000; ++i) {
                final KeyGenerator key = this.mcatKey.setForTicketWithoutToday(assetType, i);
                this.sscanToConsume(new Consumer<Collection<String>>(){

                    @Override
                    public void accept(Collection<String> strings) {
                        if (CollectionUtils.isEmpty(strings)) {
                            return;
                        }
                        Stream<String> test = strings.stream().filter(s -> StringUtils.startsWith((String)s, (String)"T")).distinct();
                        Object[] array = (String[])test.toArray(String[]::new);
                        if (ArrayUtils.isNotEmpty((Object[])array)) {
                            Long rs = jedis.srem(key.generateKey(), (String[])array);
                            deleted.addAndGet(rs);
                        }
                    }
                }, jedis, key);
            }
            log.info("\u6210\u529f\u5220\u9664\u4e86 {} \u4e2a {} \u7c7b\u578b\u7684\u6d4b\u8bd5\u5956\u7b7e", (Object)deleted.get(), (Object)assetType);
        }
    }

    private void sscanToConsume(Consumer<Collection<String>> consumer, Jedis jedis, KeyGenerator key) {
        String cursor = "0";
        ScanParams scanParams = new ScanParams().count(Integer.valueOf(this.properties.getMaximumMembersOnceOnGrantRemovalScheduler()));
        do {
            ScanResult scanResult = jedis.sscan(key.generateKey(), cursor, scanParams);
            cursor = scanResult.getStringCursor();
            List result = scanResult.getResult();
            if (!CollectionUtils.isNotEmpty((Collection)result)) continue;
            consumer.accept(result);
        } while (!"0".equals(cursor));
    }

    @Override
    public Collection<String> listTicketWithoutToday(String assetType) {
        JedisPool jedisPool = this.getJedisPool();
        try (Jedis jedis = jedisPool.getResource();){
            ArrayList r = Lists.newArrayList();
            Pipeline pipelined = jedis.pipelined();
            for (int i = 0; i < 1000; ++i) {
                KeyGenerator key = this.mcatKey.setForTicketWithoutToday(assetType, i);
                r.add(pipelined.smembers(key.generateKey()));
            }
            HashSet all = Sets.newHashSet();
            pipelined.sync();
            for (Response response : r) {
                all.addAll((Collection)response.get());
            }
            HashSet hashSet = all;
            return hashSet;
        }
    }

    @Override
    public void removeTicketOnWithoutToday(String assetType, String id) {
        KeyGenerator key = this.mcatKey.setForTicketWithoutToday(assetType, id);
        JedisPool jedisPool = this.getJedisPool();
        try (Jedis jedis = jedisPool.getResource();){
            jedis.srem(key.generateKey(), new String[]{id});
        }
    }

    @Override
    public BigDecimal sumBonusOfToday() {
        return BigDecimal.valueOf(this.properties.getEcpm()).movePointLeft(3).multiply(BigDecimal.valueOf(this.countTicketOnToday())).multiply(BigDecimal.valueOf(this.properties.getPercentOfEcpm()).movePointLeft(2)).multiply(BigDecimal.valueOf(this.properties.getShamBonusMultiply())).movePointRight(3);
    }

    @Override
    public BigDecimal getOnceMoneyOfToday(BigDecimal bonus) {
        if (Objects.isNull(bonus) || bonus.intValue() <= 0) {
            return BigDecimal.ZERO;
        }
        long countGrantOnToday = this.countTicketOnToday();
        BigDecimal sum = BigDecimal.valueOf(countGrantOnToday);
        if (sum.equals(BigDecimal.ZERO)) {
            return BigDecimal.ZERO;
        }
        return bonus.divide(sum, 3, RoundingMode.HALF_UP);
    }

    @Override
    public BigDecimal getOnceMoneyOfToday() {
        return this.getOnceMoneyOfToday(this.sumBonusOfToday());
    }

    @Override
    public void addTicketToWithoutToday(String assetType, String ... members) {
        JedisPool jedisPool = this.getJedisPool();
        try (Jedis jedis = jedisPool.getResource();){
            Pipeline pipelined = jedis.pipelined();
            for (String member : members) {
                String key = this.mcatKey.setForTicketWithoutToday(assetType, member).generateKey();
                pipelined.sadd(key, new String[]{member});
            }
            pipelined.sync();
        }
    }

    private JedisPool getJedisPool() {
        Object clientOriginal = this.fetcher.getClientOriginal();
        if (!(clientOriginal instanceof JedisPool)) {
            throw new RuntimeException("clientOriginal is not JedisPool!");
        }
        return (JedisPool)clientOriginal;
    }
}

