/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.mcat.common.ticket.steps;

import com.bxm.game.mcat.common.McatProperties;
import com.bxm.game.mcat.common.ticket.statistics.StatisticsService;
import com.bxm.game.mcat.common.ticket.steps.Step;
import com.bxm.game.mcat.common.ticket.steps.StepDataTracker;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ComputeWinRatioStepImpl
implements Step {
    private static final Logger log = LoggerFactory.getLogger(ComputeWinRatioStepImpl.class);
    private final McatProperties properties;
    private final StepDataTracker stepDataTracker;
    private final StatisticsService statisticsService;

    public ComputeWinRatioStepImpl(McatProperties properties, StepDataTracker stepDataTracker, StatisticsService statisticsService) {
        this.properties = properties;
        this.stepDataTracker = stepDataTracker;
        this.statisticsService = statisticsService;
    }

    public int getOrder() {
        return 0;
    }

    @Override
    public void compute() {
        if (!this.stepDataTracker.isSyncCompleted()) {
            throw new RuntimeException("\u5956\u7b7e\u540c\u6b65\u672a\u5b8c\u6210\uff0c\u4e0d\u80fd\u8ba1\u7b97\u4e2d\u5956\u7387\u3002");
        }
        long bronze = this.statisticsService.computeCountTicketOnYesterday("bronze");
        long silver = this.statisticsService.computeCountTicketOnYesterday("silver");
        long gold = this.statisticsService.computeCountTicketOnYesterday("gold");
        long diamond = this.statisticsService.computeCountTicketOnYesterday("diamond");
        McatProperties.PropConfig propConfig = this.properties.getProp();
        int ratioWinBronze = propConfig.getRatioWinBronze();
        int ratioWinSilver = propConfig.getRatioWinSilver();
        int ratioWinGold = propConfig.getRatioWinGold();
        int ratioWinDiamond = propConfig.getRatioWinDiamond();
        long winsBronze = BigDecimal.valueOf(bronze).multiply(BigDecimal.valueOf(ratioWinBronze).movePointLeft(2)).longValue();
        long winsSilver = BigDecimal.valueOf(silver).multiply(BigDecimal.valueOf(ratioWinSilver).movePointLeft(2)).longValue();
        long winsGold = BigDecimal.valueOf(gold).multiply(BigDecimal.valueOf(ratioWinGold).movePointLeft(2)).longValue();
        long winsDiamond = BigDecimal.valueOf(diamond).multiply(BigDecimal.valueOf(ratioWinDiamond).movePointLeft(2)).longValue();
        long notWinBronze = this.statisticsService.countTicketWithoutToday("bronze");
        long notWinSilver = this.statisticsService.countTicketWithoutToday("silver");
        long notWinGold = this.statisticsService.countTicketWithoutToday("gold");
        long notWinDiamond = this.statisticsService.countTicketWithoutToday("diamond");
        if (winsBronze > notWinBronze || winsSilver > notWinSilver || winsGold > notWinGold || winsDiamond > notWinDiamond) {
            throw new RuntimeException("\u53ef\u4e2d\u5956\u7684\u5956\u7b7e\u6570\u4e0d\u80fd\u5927\u4e8e\u5386\u53f2\u672a\u5151\u5956\u7684\u5956\u7b7e\u6570\u3002");
        }
        BigDecimal ratioWinOfBronze = this.divide(winsBronze, notWinBronze);
        BigDecimal ratioWinOfSilver = this.divide(winsSilver, notWinSilver);
        BigDecimal ratioWinOfGold = this.divide(winsGold, notWinGold);
        BigDecimal ratioWinOfDiamond = this.divide(winsDiamond, notWinDiamond);
        log.info("===\u7edf\u8ba1\u5956\u7b7e\u53ca\u5151\u73b0\u6982\u7387===\n\u6628\u65e5\u83b7\u5956\u7b7e\u7edf\u8ba1\uff1abronze={}\tsilver={}\tgold={}\tdiamond={}\n\u62df\u4e2d\u7b7e\u6982\u7387\u914d\u7f6e\uff1abronze={}\tsilver={}\tgold={}\tdiamond={}\n\u62df\u4e2d\u5956\u5956\u7b7e\u7edf\u8ba1\uff1abronze={}\tsilver={}\tgold={}\tdiamond={}\n\u603b\u672a\u4e2d\u5956\u7b7e\u7edf\u8ba1\uff1abronze={}\tsilver={}\tgold={}\tdiamond={}\n\u6700\u7ec8\u53ef\u4e2d\u5956\u6982\u7387\uff1abronze={}\tsilver={}\tgold={}\tdiamond={}", new Object[]{bronze, silver, gold, diamond, ratioWinBronze, ratioWinSilver, ratioWinGold, ratioWinDiamond, winsBronze, winsSilver, winsGold, winsDiamond, notWinBronze, notWinSilver, notWinGold, notWinDiamond, ratioWinOfBronze, ratioWinOfSilver, ratioWinOfGold, ratioWinOfDiamond});
        HashMap value = Maps.newHashMap();
        value.put("bronze", ratioWinOfBronze.toString());
        value.put("silver", ratioWinOfSilver.toString());
        value.put("gold", ratioWinOfGold.toString());
        value.put("diamond", ratioWinOfDiamond.toString());
        this.stepDataTracker.setWinRatio(value);
        this.stepDataTracker.setGrantCount(bronze + silver + gold + diamond);
        log.info("\u6700\u7ec8\u53ef\u4e2d\u5956\u6982\u7387\u5df2\u4fdd\u5b58");
    }

    private BigDecimal divide(long winsBronze, long notWinBronze) {
        if (notWinBronze == 0L) {
            return BigDecimal.ONE;
        }
        return BigDecimal.valueOf(winsBronze).divide(BigDecimal.valueOf(notWinBronze), 6, RoundingMode.HALF_UP);
    }
}

