/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.mcat.common.ticket.steps;

import com.bxm.game.mcat.common.McatKey;
import com.bxm.game.mcat.common.ticket.steps.StepDataTracker;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.Updater;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Configuration
public class RedisStepDataTrackerImpl
implements StepDataTracker {
    private final McatKey mcatKey;
    private final Fetcher fetcher;
    private final Updater updater;
    private final Counter counter;

    public RedisStepDataTrackerImpl(McatKey mcatKey, Fetcher fetcher, Updater updater, Counter counter) {
        this.mcatKey = mcatKey;
        this.fetcher = fetcher;
        this.updater = updater;
        this.counter = counter;
    }

    @Override
    public void setSyncState() {
        this.counter.hincrementAndGet(this.mcatKey.hashComputeCache(), "syncState", this.getExpireTimeOfDays(7));
    }

    @Override
    public boolean isSyncCompleted() {
        return Optional.of(this.counter.hget(this.mcatKey.hashComputeCache(), "syncState")).orElse(0L) > 0L;
    }

    @Override
    public void setWinRatio(Map<String, String> ratio) {
        this.updater.hmupdate(this.mcatKey.hashWinnerRatio(), ratio, this.getExpireTimeOfDays(7));
    }

    @Override
    public void setWinnerProcessingState() {
        this.counter.hincrementAndGet(this.mcatKey.hashComputeCache(), "winnerProcessingState", this.getExpireTimeOfDays(7));
    }

    @Override
    public boolean isWinnerProcessCompleted() {
        return Optional.of(this.counter.hget(this.mcatKey.hashComputeCache(), "winnerProcessingState")).orElse(0L) > 0L;
    }

    @Override
    public Map<String, String> getWinRatio() {
        return this.fetcher.hfetchall(this.mcatKey.hashWinnerRatio(), String.class);
    }

    @Override
    public void setGrantCount(long grantCount) {
        this.updater.hupdate(this.mcatKey.hashComputeCache(), "grantCount", (Object)grantCount, this.getExpireTimeOfDays(7));
    }

    @Override
    public long getGrantCount() {
        return (Long)Optional.ofNullable(this.fetcher.hfetch(this.mcatKey.hashComputeCache(), "grantCount", Long.class)).orElse(0L);
    }

    @Override
    public void cleanWinners(String assetType) {
        if (StringUtils.isBlank((String)assetType)) {
            return;
        }
        this.updater.remove(this.mcatKey.setWinners(assetType));
    }

    @Override
    public void addWinners(String assetType, Set<String> winners) {
        if (StringUtils.isBlank((String)assetType) || CollectionUtils.isEmpty(winners)) {
            return;
        }
        this.updater.supdate(this.mcatKey.setWinners(assetType), 86400, winners.toArray(new String[0]));
    }

    @Override
    public List<String> removeWinners(String assetType) {
        JedisPool jedisPool = this.getJedisPool();
        try (Jedis jedis = jedisPool.getResource();){
            List srandmember = jedis.srandmember(this.mcatKey.setWinners(assetType).generateKey(), 1000);
            if (CollectionUtils.isNotEmpty((Collection)srandmember)) {
                jedis.srem(this.mcatKey.setWinners(assetType).generateKey(), srandmember.toArray(new String[0]));
            }
            List list = srandmember;
            return list;
        }
    }

    private JedisPool getJedisPool() {
        Object clientOriginal = this.fetcher.getClientOriginal();
        if (!(clientOriginal instanceof JedisPool)) {
            throw new RuntimeException("clientOriginal is not JedisPool!");
        }
        return (JedisPool)clientOriginal;
    }

    @Override
    public void setWinnerCount(long winner) {
        this.updater.hupdate(this.mcatKey.hashComputeCache(), "winnerCount", (Object)winner, this.getExpireTimeOfDays(7));
    }

    @Override
    public long getWinnerCount() {
        return (Long)Optional.ofNullable(this.fetcher.hfetch(this.mcatKey.hashComputeCache(), "winnerCount", Long.class)).orElse(0L);
    }

    @Override
    public void setBonus(long money) {
        this.updater.hupdate(this.mcatKey.hashComputeCache(), "bonus", (Object)money, this.getExpireTimeOfDays(7));
    }

    @Override
    public long getBonus() {
        return (Long)Optional.ofNullable(this.fetcher.hfetch(this.mcatKey.hashComputeCache(), "bonus", Long.class)).orElse(0L);
    }

    @Override
    public void setMoney(long money) {
        this.updater.hupdate(this.mcatKey.hashComputeCache(), "money", (Object)money, this.getExpireTimeOfDays(7));
    }

    @Override
    public long getMoney() {
        return (Long)Optional.ofNullable(this.fetcher.hfetch(this.mcatKey.hashComputeCache(), "money", Long.class)).orElse(0L);
    }

    @Override
    public void plusAcceptBonus(long amount) {
        this.counter.hincrementByAndGet(this.mcatKey.hashComputeCache(), "acceptBonus", amount, this.getExpireTimeOfDays(7));
    }

    @Override
    public long getNotAcceptBonus() {
        long total = this.getBonus();
        long noAccept = Optional.ofNullable(this.counter.hget(this.mcatKey.hashComputeCache(), "acceptBonus")).orElse(0L);
        return total - noAccept;
    }

    private int getExpireTimeOfDays(int days) {
        return 86400 * days;
    }
}

