/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.mcat.common.ticket.winner;

import com.bxm.game.common.core.ErrCode;
import com.bxm.game.common.core.GameException;
import com.bxm.game.common.core.Key;
import com.bxm.game.common.core.assets.AssetService;
import com.bxm.game.common.core.prop.AcquiredPropLog;
import com.bxm.game.common.core.prop.PropService;
import com.bxm.game.mcat.common.Constants;
import com.bxm.game.mcat.common.ErrCodes;
import com.bxm.game.mcat.common.McatProperties;
import com.bxm.game.mcat.common.money.MoneyService;
import com.bxm.game.mcat.common.ticket.statistics.MutableStatisticsService;
import com.bxm.game.mcat.common.ticket.steps.StepDataTracker;
import com.bxm.game.mcat.common.ticket.winner.Winner;
import com.bxm.game.mcat.common.ticket.winner.WinnerService;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.NamedThreadFactory;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Duration;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service
public class WinnerServiceImpl
implements WinnerService {
    private static final Logger log = LoggerFactory.getLogger(WinnerServiceImpl.class);
    private final McatProperties properties;
    private final PropService propService;
    private final StepDataTracker stepDataTracker;
    private final MutableStatisticsService mutableStatisticsService;
    private final AssetService assetService;
    private final MoneyService moneyService;
    private final Fetcher fetcher;
    private final Updater updater;
    private final Counter counter;
    private final Key key;
    private final ThreadPoolExecutor batch = new ThreadPoolExecutor(1000, 1000, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("batch-insert"));

    public WinnerServiceImpl(McatProperties properties, PropService propService, StepDataTracker stepDataTracker, MutableStatisticsService mutableStatisticsService, AssetService assetService, MoneyService moneyService, Fetcher fetcher, Updater updater, Counter counter, Key key) {
        this.properties = properties;
        this.propService = propService;
        this.stepDataTracker = stepDataTracker;
        this.mutableStatisticsService = mutableStatisticsService;
        this.assetService = assetService;
        this.moneyService = moneyService;
        this.fetcher = fetcher;
        this.updater = updater;
        this.counter = counter;
        this.key = key;
    }

    @Override
    public long incrementIssue() {
        return this.counter.incrementAndGet(this.stringIssue());
    }

    @Override
    public long getIssue() {
        return (Long)Optional.ofNullable(this.fetcher.fetch(this.stringIssue(), Long.class)).orElse(0L);
    }

    @Override
    public void finished() {
        this.counter.incrementAndGet(this.stringFinished(), 86400);
    }

    @Override
    public boolean isFinished() {
        return (Long)Optional.ofNullable(this.fetcher.fetch(this.stringFinished(), Long.class)).orElse(0L) > 0L;
    }

    @Override
    public Winner get(String uid) {
        LocalTime now = LocalTime.now();
        if (now.isBefore(Constants.EIGHT) || now.isAfter(Constants.TWELVE)) {
            return null;
        }
        HashMap<String, String> map = this.fetcher.hfetchall(this.hashWinnerStat(uid), String.class);
        if (MapUtils.isEmpty((Map)map)) {
            map = new HashMap<String, String>();
        }
        Winner winner = Winner.builder().uid(uid).winCount(this.computeOrGetWinCount(map, uid)).winMoney(this.computeOrGetWinMoney(map, uid)).accepted(NumberUtils.toInt((String)((String)map.get(Field.accepted.name()))) > 0).build();
        this.updater.hmupdate(this.hashWinnerStat(uid), map, 86400);
        return winner;
    }

    private long computeOrGetWinCount(Map<String, String> map, String uid) {
        long count = NumberUtils.toLong((String)map.get(Field.count.name()));
        if (count > 0L) {
            return count;
        }
        JedisPool jedisPool = this.getJedisPool();
        try (Jedis jedis = jedisPool.getResource();){
            count = jedis.hlen(this.hashWinnerLog(uid).generateKey());
            map.put(Field.count.name(), Objects.toString(count));
            long l = count;
            return l;
        }
    }

    private long computeOrGetWinMoney(Map<String, String> map, String uid) {
        String s = map.get(Field.money.name());
        if (StringUtils.isNotBlank((String)s)) {
            return NumberUtils.toLong((String)s);
        }
        long money = 0L;
        Map logs = this.fetcher.hfetchall(this.hashWinnerLog(uid), AcquiredPropLog.class);
        if (MapUtils.isEmpty((Map)logs)) {
            return money;
        }
        for (Map.Entry entry : logs.entrySet()) {
            AcquiredPropLog log = (AcquiredPropLog)entry.getValue();
            money += this.computeMoney(log.getAssetType());
        }
        map.put(Field.money.name(), Objects.toString(money));
        return money;
    }

    @Override
    public void accept(String uid) {
        if (!this.isFinished()) {
            return;
        }
        if (this.counter.hincrementAndGet(this.hashWinnerStat(uid), Field.accepted.name(), 86400) > 1L) {
            throw new GameException(ErrCodes.BONUS_ACQUIRED);
        }
        if (LocalTime.now().isAfter(Constants.TWELVE)) {
            throw new GameException(ErrCodes.WINNER_TIMEOUT);
        }
        Map logs = this.fetcher.hfetchall(this.hashWinnerLog(uid), AcquiredPropLog.class);
        if (MapUtils.isEmpty((Map)logs)) {
            throw new GameException(ErrCodes.NOT_WINNER);
        }
        Winner winner = this.get(uid);
        if (Objects.isNull(winner)) {
            throw new GameException(ErrCode.INTERNAL_SERVER_ERROR);
        }
        long winMoney = winner.getWinMoney();
        if (winMoney <= 0L) {
            throw new GameException(ErrCodes.NOT_WINNER);
        }
        for (Map.Entry entry : logs.entrySet()) {
            String id = (String)entry.getKey();
            AcquiredPropLog log = (AcquiredPropLog)entry.getValue();
            this.mutableStatisticsService.removeTicketOnWithoutToday(log.getAssetType(), id);
            int value = log.getPropNum();
            if (log.isCompletedMultiple()) {
                value *= log.getMultipleNum();
            }
            this.assetService.minus(log.getAssetType(), (long)value);
        }
        this.moneyService.plus(winMoney);
        this.stepDataTracker.plusAcceptBonus(winMoney);
    }

    @Override
    public boolean insert(String id) {
        AcquiredPropLog takeLog = this.propService.getTakeLog(id);
        String uid = takeLog.getUid();
        try {
            this.updater.hupdate(this.hashWinnerLog(uid), id, (Object)takeLog, WinnerServiceImpl.getExpireTimeInMillis(Constants.TWELVE));
            return true;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return false;
        }
    }

    @Override
    public void asyncInsert(final String id, final Consumer<Boolean> callable) {
        this.batch.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                boolean b = WinnerServiceImpl.this.insert(id);
                callable.accept(b);
                return b;
            }
        });
    }

    @Override
    public long computeMoney(long money, String assetType) {
        switch (assetType) {
            case "bronze": {
                return BigDecimal.valueOf(money).multiply(BigDecimal.valueOf(this.properties.getProp().getMultipleMoneyBronze())).setScale(0, RoundingMode.HALF_UP).longValue();
            }
            case "silver": {
                return BigDecimal.valueOf(money).multiply(BigDecimal.valueOf(this.properties.getProp().getMultipleMoneySilver())).setScale(0, RoundingMode.HALF_UP).longValue();
            }
            case "gold": {
                return BigDecimal.valueOf(money).multiply(BigDecimal.valueOf(this.properties.getProp().getMultipleMoneyGold())).setScale(0, RoundingMode.HALF_UP).longValue();
            }
            case "diamond": {
                return BigDecimal.valueOf(money).multiply(BigDecimal.valueOf(this.properties.getProp().getMultipleMoneyDiamond())).setScale(0, RoundingMode.HALF_UP).longValue();
            }
        }
        throw new IllegalStateException("Unsupported assetType: " + assetType);
    }

    private JedisPool getJedisPool() {
        Object clientOriginal = this.fetcher.getClientOriginal();
        if (!(clientOriginal instanceof JedisPool)) {
            throw new RuntimeException("clientOriginal is not JedisPool!");
        }
        return (JedisPool)clientOriginal;
    }

    private long computeMoney(String assetType) {
        long money = this.stepDataTracker.getMoney();
        return this.computeMoney(money, assetType);
    }

    private KeyGenerator stringIssue() {
        return this.key.generator(new String[]{"winner", "issue"});
    }

    private KeyGenerator stringFinished() {
        return this.key.generator(new String[]{"winner", "finished", DateHelper.getDate(), Objects.toString(this.getIssue())});
    }

    private KeyGenerator hashWinnerLog(String uid) {
        return this.key.generator(new String[]{"winner", "log", DateHelper.getDate(), Objects.toString(this.getIssue()), uid});
    }

    private KeyGenerator hashWinnerStat(String uid) {
        return this.key.generator(new String[]{"winner", "stat", DateHelper.getDate(), Objects.toString(this.getIssue()), uid});
    }

    private static int getExpireTimeInMillis(LocalTime expireTime) {
        Duration duration = Duration.between(LocalTime.now(), expireTime);
        int seconds = BigDecimal.valueOf(duration.toMillis()).divide(BigDecimal.valueOf(1000L), 0, RoundingMode.HALF_UP).intValue();
        int time = seconds + RandomUtils.nextInt((int)5, (int)600);
        return time <= 0 ? 86400 : time;
    }

    public static enum Field {
        count,
        money,
        accepted;

    }
}

