/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.mcat.common.user;

import com.bxm.game.common.core.Key;
import com.bxm.game.mcat.common.user.UserService;
import com.bxm.game.mcat.common.util.MurmurHash;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class RedisUserServiceImpl
implements UserService {
    private final Key key;
    private final Fetcher fetcher;
    private final Updater updater;
    private final Counter counter;

    public RedisUserServiceImpl(Key key, Fetcher fetcher, Updater updater, Counter counter) {
        this.key = key;
        this.fetcher = fetcher;
        this.updater = updater;
        this.counter = counter;
    }

    @Override
    public long getUserId(String uid) {
        long hash64 = MurmurHash.hash64(uid);
        long m = Math.abs(hash64 % 1000L);
        KeyGenerator keyGenerator = this.key.generator(new String[]{"usermap", StringUtils.leftPad((String)Objects.toString(m, "0"), (int)3, (char)'0')});
        Long id = (Long)this.fetcher.hfetch(keyGenerator, uid, Long.class);
        if (Objects.isNull(id)) {
            id = this.counter.incrementAndGet(this.key.generator(new String[]{"usermap", "sequence"}));
            this.updater.hupdate(keyGenerator, uid, (Object)id);
        }
        return Optional.ofNullable(id).orElse(-1L);
    }
}

