package com.bxm.gateway.constant;

import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

/**
 * 网关相关的静态变量定义
 *
 * @author liujia
 */
public class GatewayConstant {

    /**
     * 请求中的用户ID键值
     */
    public static final String USER_ID_KEY = "userId";

    /**
     * 客户端版本号
     */
    public static final String CLIENT_APP_VERSION_KEY = "curVer";

    /**
     * 客户端平台,1:android，2：ios
     */
    public static final String CLIENT_PLATFORM_KEY = "platform";

    /**
     * 内嵌平台类型（给前端用的）,1:h5
     */
    public static final String NESTED_PLATFORM_KEY = "nestedPlatform";

    /**
     * 请求应用的来源
     */
    public static final String SOURCE_APP = "srcApp";

    /**
     * 需要鉴权的路径标识
     */
    public static final String AUTH_REGULATION_KEY = "security";

    /**
     * 请求路径是否包含版本标识
     */
    public static final String HAS_VERSION = "hv";

    /**
     * 蛋蛋佳续约token标识
     */
    public static final String EGG_RENEW_TOKEN_FLAG_NAME = "eggRenew";

    /**
     * 蛋蛋佳续约token标识
     */
    public static final String REQUIRED_EGG_RENEW_TOKEN_FLAG = "renew";

    /**
     * 蛋蛋佳续约token header名称
     */
    public static final String RENEW_EGG_ACCESS_TOKEN_HEADER_NAME = "renew-access-token";

    /**
     * 蛋蛋佳续约refresh token header名称
     */
    public static final String RENEW_EGG_REFRESH_TOKEN_HEADER_NAME = "renew-refresh-token";

    public static final Marker ACCESS = MarkerFactory.getMarker("access");


    private GatewayConstant() {

    }


}
