package com.bxm.gateway.integration;

import com.alibaba.fastjson.JSON;
import com.bxm.egg.user.facade.bo.UserTokenBO;
import com.bxm.egg.user.facade.service.UserTokenFacadeService;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Service;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/10/19 1:56 下午
 */
@Slf4j
@Service
public class EggTokenIntegrationService {
    @DubboReference(protocol = "dubbo",
            mock = "com.bxm.egg.user.facade.mock.UserTokenFacadeServiceMock",
            cluster = "failfast",
            version = "1.0.0",
            check = false,
            lazy = true
    )
    private UserTokenFacadeService userTokenFacadeService;

    /**
     * 刷新AccessToken
     *
     * @param userId 用户id
     * @return 刷新之后的token
     */
    public UserTokenBO renewToken(Long userId) {
        UserTokenBO userTokenBO = userTokenFacadeService.renewToken(userId);

        if (log.isDebugEnabled()) {
            log.debug("用户:{},刷新后的AccessToken:{}", userId, JSON.toJSONString(userTokenBO));
        }
        return userTokenBO;
    }
}