package com.bxm.gateway.properties;

import com.google.common.collect.Lists;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.List;

/**
 * 业务配置信息
 *
 * @author liujia
 */
@ConfigurationProperties(prefix = "api.gateway")
@Data
public class GatewayProperties {


    /**
     * 允许访问系统的请求来源
     */
    private String allowedOrigins = "*";

    /**
     * 允许请求来源
     */
    private String allowOrigins = "*";

    /**
     * 不记录访问日志的路径
     */
    private List<String> ignoreAccessLogUrls = Lists.newArrayList();
}
