package com.bxm.gateway.properties;

import lombok.Data;

/**
 * swagger api配置
 * key：自定义模块别名
 * value：服务相关配置
 */
@Data
public class SwaggerConfig {

    /**
     * 服务名称，与eureka中定义的一致
     */
    private String serviceName;

    /**
     * 服务当前版本
     */
    private String version;

    /**
     * 分组名称，需要与对应服务中的swagger分组名称一致
     */
    private String groupName;

    /**
     * 排序
     */
    private int order;
}