package com.bxm.gateway.properties;

import com.google.common.collect.Maps;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.Map;

/**
 * swagger 相关配置
 *
 * @author liujia
 * @date 6/2/21 4:19 PM
 **/
@ConfigurationProperties(prefix = "api.gateway.swagger")
@Data
public class SwaggerProperties {

    /**
     * swagger配置,用于配置不同服务的API
     */
    private Map<String, SwaggerConfig> config = Maps.newHashMap();
}
