package com.bxm.gateway.utils;

import java.util.regex.Pattern;

public class ApiVersionUtils {

    private final static String PATTERN = "/v(\\d+)/";

    private final static Pattern VERSION_PATTERN = Pattern.compile(PATTERN);

    private ApiVersionUtils() {
    }

    public static boolean hasPrefix(String urlPath) {
        return urlPath.startsWith("/v") && VERSION_PATTERN.matcher(urlPath).find();
    }

    public static String replace(String urlPath) {
        if (hasPrefix(urlPath)) {
            return VERSION_PATTERN.matcher(urlPath).replaceFirst("/");
        }
        return urlPath;
    }
}
