package com.bxm.gateway.utils;

import com.bxm.newidea.component.JSONArray;
import com.bxm.newidea.component.JSONObject;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.util.WebUtils;
import com.netflix.zuul.context.RequestContext;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;

@Slf4j
public class RequestUtils {
    private RequestUtils() {

    }

    public static String getField(HttpServletRequest request, String fieldName) {
        Map<String, String[]> paramMap = request.getParameterMap();
        String[] fieldVal = paramMap.get(fieldName);
        if (null != fieldVal && fieldVal.length > 0) {
            return fieldVal[0];
        }

        try {
            if (RequestMethod.POST.name().equalsIgnoreCase(request.getMethod()) ||
                    RequestMethod.PUT.name().equalsIgnoreCase(request.getMethod()) ||
                    RequestMethod.DELETE.name().equalsIgnoreCase(request.getMethod())) {
                JSONObject json = JSONObject.parseObject(WebUtils.getRequestBodyContent(request));
                return findField(json, fieldName);
            }
        } catch (Exception e) {
            log.info("解析请求出错,错误信息：{}", e.getMessage(), e);
        }

        return StringUtils.EMPTY;
    }

    private static String findField(JSONObject json, String fieldName) {
        if (null == json) {
            return StringUtils.EMPTY;
        }
        Object jsonVal = json.get(fieldName);
        if (null == jsonVal) {
            Collection<Object> values = json.values();
            for (Object value : values) {
                if (value instanceof JSONArray) {
                    JSONArray array = (JSONArray) value;
                    if (array.size() > 0 && array.get(0) instanceof JSONObject) {
                        for (int i = 0; i < array.size(); i++) {
                            String arrayObjVal = findField(array.getJSONObject(i), fieldName);
                            if (null != arrayObjVal) {
                                return arrayObjVal;
                            }
                        }
                    }
                } else if (value instanceof JSONObject) {
                    return findField((JSONObject) value, fieldName);
                }
            }
        }
        return Objects.toString(jsonVal);
    }

    /**
     * 从请求中获取字段,优先从上下文获取
     * 获取不到时从请求、请求头中获取，然后设置到上下文
     *
     * @param requestContext 请求上下文
     * @return 字段信息
     */
    public static String getRequestField(RequestContext requestContext, String fieldName) {
        Object value = requestContext.get(fieldName);

        if (null == value) {
            HttpServletRequest request = requestContext.getRequest();

            value = RequestUtils.getField(request, fieldName);

            if (null != value) {
                requestContext.put(fieldName, value);
            }
        }

        if (null == value) {
            return null;
        }

        return value.toString();
    }

    /**
     * 获取请求的UA
     *
     * @param request 请求信息
     * @return 请求的UA
     */
    public static String getUserAgent(HttpServletRequest request) {
        return request.getHeader("User-Agent");
    }
}
