package com.bxm.gateway.zuul.filter;

import com.bxm.gateway.utils.RequestUtils;
import com.bxm.newidea.component.util.WebUtils;
import com.netflix.zuul.ZuulFilter;
import lombok.extern.slf4j.Slf4j;

import javax.servlet.http.HttpServletRequest;

@Slf4j
public abstract class AbstractZuulFilter extends ZuulFilter {

    @Override
    public int filterOrder() {
        return FilterOrder.get(getClass());
    }

    @Override
    public boolean shouldFilter() {
        return true;
    }

    protected void logError(String message, HttpServletRequest request) {
        log.error(message + "IP:[{}],URI:[{}],UA[{}],PARAM:[{}]",
                WebUtils.getIpAddr(request),
                request.getRequestURI(),
                RequestUtils.getUserAgent(request),
                WebUtils.getRequestParam(request));
    }

    protected void logInfo(String message, HttpServletRequest request) {
        log.info(message + "IP:[{}],URI:[{}],UA[{}],PARAM:[{}]",
                WebUtils.getIpAddr(request),
                request.getRequestURI(),
                RequestUtils.getUserAgent(request),
                WebUtils.getRequestParam(request));
    }
}
