package com.bxm.gateway.zuul.filter;

import com.bxm.gateway.zuul.filter.impl.*;
import com.google.common.collect.Maps;
import com.netflix.zuul.ZuulFilter;

import java.util.Map;

import static org.springframework.cloud.netflix.zuul.filters.support.FilterConstants.DEBUG_FILTER_ORDER;

/**
 * 对zuul过滤器的顺序进行统一定义
 *
 * @author liujia
 */
class FilterOrder {

    private static Map<Class<? extends ZuulFilter>, Integer> orderMap = Maps.newHashMap();

    private static int order = DEBUG_FILTER_ORDER + 1;

    static {
        // 先执行低成本的过滤器，后执行高成本的过滤器
        orderMap.put(LimitPathPreFilter.class, order++);
        orderMap.put(ValidateTimestampPreFilter.class, order++);

        orderMap.put(SignaturePreFilter.class, order++);
        orderMap.put(AuthenticationPreFilter.class, order++);

        // error 排序无所谓
        orderMap.put(ErrorLogFilter.class, order++);

        orderMap.put(TokenRenewPostFilter.class, order++);
    }

    static int get(Class<? extends ZuulFilter> clasz) {
        return orderMap.get(clasz);
    }
}
