package com.bxm.gateway.zuul.filter.impl;

import com.bxm.gateway.utils.RequestUtils;
import com.bxm.gateway.zuul.filter.AbstractZuulFilter;
import com.bxm.newidea.component.util.WebUtils;
import com.netflix.zuul.context.RequestContext;
import com.netflix.zuul.exception.ZuulException;
import lombok.extern.slf4j.Slf4j;

import javax.servlet.http.HttpServletRequest;

import static org.springframework.cloud.netflix.zuul.filters.support.FilterConstants.ERROR_TYPE;

/**
 * 处理出现错误时记录相关日志
 *
 * @author gonzo
 * @date 2020-09-03 16:17
 **/
@Slf4j
public class ErrorLogFilter extends AbstractZuulFilter {

    @Override
    public String filterType() {
        return ERROR_TYPE;
    }

    @Override
    public Object run() {
        RequestContext requestContext = RequestContext.getCurrentContext();
        Throwable throwable = requestContext.getThrowable();

        HttpServletRequest request = requestContext.getRequest();
        String uri = request.getRequestURI();

        if (throwable instanceof ZuulException) {
            logError("请求不合法", request);
        } else {
            log.error("请求出错，uri:{}, param:{},UA:{}", uri,
                    WebUtils.getRequestParam(request),
                    RequestUtils.getUserAgent(request),
                    throwable);
        }

        return null;
    }


    @Override
    public int filterOrder() {
        return super.filterOrder();
    }
}
