package com.bxm.gateway.zuul.filter.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.egg.user.facade.bo.UserTokenBO;
import com.bxm.gateway.constant.GatewayConstant;
import com.bxm.gateway.integration.EggTokenIntegrationService;
import com.bxm.gateway.properties.GatewayProperties;
import com.bxm.gateway.properties.SecurityProperties;
import com.bxm.gateway.utils.RequestUtils;
import com.bxm.gateway.zuul.filter.AbstractZuulFilter;
import com.bxm.newidea.component.tools.StringUtils;
import com.netflix.zuul.context.RequestContext;
import com.netflix.zuul.exception.ZuulException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.netflix.zuul.filters.support.FilterConstants;

import java.util.Objects;

import static com.bxm.gateway.constant.GatewayConstant.*;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/10/18 2:20 下午
 */
@Slf4j
public class TokenRenewPostFilter extends AbstractZuulFilter {

    private SecurityProperties securityProperties;

    private GatewayProperties gatewayProperties;

    private EggTokenIntegrationService eggTokenIntegrationService;

    public TokenRenewPostFilter(SecurityProperties securityProperties,
                                GatewayProperties gatewayProperties,
                                EggTokenIntegrationService eggTokenIntegrationService) {
        this.securityProperties = securityProperties;
        this.gatewayProperties = gatewayProperties;
        this.eggTokenIntegrationService = eggTokenIntegrationService;
    }

    @Override
    public String filterType() {
        return FilterConstants.POST_TYPE;
    }

    @Override
    public Object run() throws ZuulException {
        RequestContext requestContext = RequestContext.getCurrentContext();

        String srcApp = RequestUtils.getRequestField(requestContext, GatewayConstant.SOURCE_APP);
        String userId = RequestUtils.getRequestField(requestContext, USER_ID_KEY);
        String eggRenewTokenFlag = RequestUtils.getRequestField(requestContext, GatewayConstant.EGG_RENEW_TOKEN_FLAG_NAME);

        //如果是蛋蛋佳才需要token续约
        if (Objects.nonNull(srcApp) && Objects.equals(srcApp, securityProperties.getEggSrcApp())) {

            if (StringUtils.isNotBlank(eggRenewTokenFlag)
                    && eggRenewTokenFlag.equals(GatewayConstant.REQUIRED_EGG_RENEW_TOKEN_FLAG)
                    && StringUtils.isNotBlank(userId)) {
                UserTokenBO userTokenBO = eggTokenIntegrationService.renewToken(Long.valueOf(userId));

                if (log.isDebugEnabled()) {
                    log.debug("用户：{},重新续约生成accessToken：{}", userId, JSON.toJSONString(userTokenBO));
                }
                if (userTokenBO != null) {
                    requestContext.getResponse().setHeader(RENEW_EGG_ACCESS_TOKEN_HEADER_NAME, userTokenBO.getReNewAccessToken());
                    requestContext.getResponse().setHeader(RENEW_EGG_REFRESH_TOKEN_HEADER_NAME, userTokenBO.getReNewRefreshToken());
                }
            }
        }

        return null;
    }

}