package com.bxm.gateway.zuul.filter.impl;

import com.bxm.gateway.properties.SecurityProperties;
import com.bxm.gateway.utils.RequestUtils;
import com.bxm.gateway.zuul.filter.AbstractZuulFilter;
import com.bxm.newidea.component.util.WebUtils;
import com.netflix.zuul.context.RequestContext;
import com.netflix.zuul.exception.ZuulException;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.http.HttpStatus;

import javax.servlet.http.HttpServletRequest;

import static com.bxm.gateway.utils.RequestUtils.getRequestField;
import static org.springframework.cloud.netflix.zuul.filters.support.FilterConstants.PRE_TYPE;

/**
 * @author liujia
 * @date 6/2/21 4:56 PM
 **/
@Slf4j
public class ValidateTimestampPreFilter extends AbstractZuulFilter {

    private SecurityProperties securityProperties;

    public ValidateTimestampPreFilter(SecurityProperties securityProperties) {
        this.securityProperties = securityProperties;
    }

    @Override
    public String filterType() {
        return PRE_TYPE;
    }

    @Override
    public Object run() throws ZuulException {
        
        if (securityProperties.isEnableApiTimestampValidate()) {
            RequestContext requestContext = RequestContext.getCurrentContext();
            HttpServletRequest request = requestContext.getRequest();

            String cliTime = getRequestField(requestContext, "cliTime");

            if (NumberUtils.isDigits(cliTime)) {
                long deviateVal = Math.abs(Long.valueOf(cliTime) - System.currentTimeMillis());

                if (deviateVal > securityProperties.getExpiredRequestMilliseconds()) {
                    log.error("请求时间戳错误,请求IP：[{}]，请求参数：[{}],偏差值：[{}]，UA:[{}]",
                            WebUtils.getIpAddr(request),
                            WebUtils.getRequestParam(request),
                            deviateVal,
                            RequestUtils.getUserAgent(request));

                    throw new ZuulException("非法请求", HttpStatus.BAD_REQUEST.value(), "请求时间不在合法范围");
                }
            } else if (null != cliTime) {
                logError("请求中的cliTime不是一个有效的时间格式", request);
            } else {
                logInfo("请求未提供时间戳", request);
            }
        }

        return null;
    }
}
