package com.bxm.gateway.zuul.route;

import com.bxm.gateway.utils.ApiVersionUtils;
import org.springframework.cloud.netflix.zuul.filters.RefreshableRouteLocator;
import org.springframework.cloud.netflix.zuul.filters.Route;
import org.springframework.cloud.netflix.zuul.filters.SimpleRouteLocator;
import org.springframework.cloud.netflix.zuul.filters.ZuulProperties;

/**
 * @author liujia
 * @date 6/30/21 11:39 AM
 **/
public class DynamicRouteLocator extends SimpleRouteLocator implements RefreshableRouteLocator {

    public DynamicRouteLocator(String servletPath, ZuulProperties properties) {
        super(servletPath, properties);
    }

    @Override
    public Route getMatchingRoute(String path) {
        boolean hasVersion = ApiVersionUtils.hasPrefix(path);

        if (hasVersion) {
            Route route = super.getMatchingRoute(ApiVersionUtils.replace(path));
            route.setPath(path);
            route.setFullPath(path);
            return route;
        } else {
            return super.getMatchingRoute(path);
        }
    }

    @Override
    public void refresh() {
        doRefresh();
    }
}
