/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.gateway.properties;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="api.gateway.security")
public class SecurityProperties {
    private Map<String, String> appTokenSecret = Maps.newHashMap();
    private long accessTokenExpired = 720000L;
    private long refreshTokenExpired = 2592000L;
    private long tokenRenew = 1800L;
    private boolean enableAuth = true;
    private boolean checkTokenUserIdConsistency = true;
    private List<String> checkTokenUrls = Lists.newArrayList();
    private List<String> skipCheckTokenUrls = Lists.newArrayList();
    private boolean enableApiTimestampValidate = true;
    private boolean enableSignature = true;
    private Map<String, SignatureConfig> appSign = Maps.newHashMap();
    private Map<String, NestedSignatureConfig> nestedSign = Maps.newHashMap();
    private long expiredRequestMilliseconds = 30000L;
    private int eggAccessTokenExpiredSeconds = 1800;
    public List<String> skipSignUrls = Lists.newArrayList();
    public List<String> skipSignSrcApp = Lists.newArrayList();
    private List<String> limitPath = Lists.newArrayList();
    private Boolean openAuthentication = true;
    private int accessTokenRenewSeconds = 300;
    private String eggSrcApp = "egg";

    public Map<String, String> getAppTokenSecret() {
        return this.appTokenSecret;
    }

    public long getAccessTokenExpired() {
        return this.accessTokenExpired;
    }

    public long getRefreshTokenExpired() {
        return this.refreshTokenExpired;
    }

    public long getTokenRenew() {
        return this.tokenRenew;
    }

    public boolean isEnableAuth() {
        return this.enableAuth;
    }

    public boolean isCheckTokenUserIdConsistency() {
        return this.checkTokenUserIdConsistency;
    }

    public List<String> getCheckTokenUrls() {
        return this.checkTokenUrls;
    }

    public List<String> getSkipCheckTokenUrls() {
        return this.skipCheckTokenUrls;
    }

    public boolean isEnableApiTimestampValidate() {
        return this.enableApiTimestampValidate;
    }

    public boolean isEnableSignature() {
        return this.enableSignature;
    }

    public Map<String, SignatureConfig> getAppSign() {
        return this.appSign;
    }

    public Map<String, NestedSignatureConfig> getNestedSign() {
        return this.nestedSign;
    }

    public long getExpiredRequestMilliseconds() {
        return this.expiredRequestMilliseconds;
    }

    public int getEggAccessTokenExpiredSeconds() {
        return this.eggAccessTokenExpiredSeconds;
    }

    public List<String> getSkipSignUrls() {
        return this.skipSignUrls;
    }

    public List<String> getSkipSignSrcApp() {
        return this.skipSignSrcApp;
    }

    public List<String> getLimitPath() {
        return this.limitPath;
    }

    public Boolean getOpenAuthentication() {
        return this.openAuthentication;
    }

    public int getAccessTokenRenewSeconds() {
        return this.accessTokenRenewSeconds;
    }

    public String getEggSrcApp() {
        return this.eggSrcApp;
    }

    public void setAppTokenSecret(Map<String, String> appTokenSecret) {
        this.appTokenSecret = appTokenSecret;
    }

    public void setAccessTokenExpired(long accessTokenExpired) {
        this.accessTokenExpired = accessTokenExpired;
    }

    public void setRefreshTokenExpired(long refreshTokenExpired) {
        this.refreshTokenExpired = refreshTokenExpired;
    }

    public void setTokenRenew(long tokenRenew) {
        this.tokenRenew = tokenRenew;
    }

    public void setEnableAuth(boolean enableAuth) {
        this.enableAuth = enableAuth;
    }

    public void setCheckTokenUserIdConsistency(boolean checkTokenUserIdConsistency) {
        this.checkTokenUserIdConsistency = checkTokenUserIdConsistency;
    }

    public void setCheckTokenUrls(List<String> checkTokenUrls) {
        this.checkTokenUrls = checkTokenUrls;
    }

    public void setSkipCheckTokenUrls(List<String> skipCheckTokenUrls) {
        this.skipCheckTokenUrls = skipCheckTokenUrls;
    }

    public void setEnableApiTimestampValidate(boolean enableApiTimestampValidate) {
        this.enableApiTimestampValidate = enableApiTimestampValidate;
    }

    public void setEnableSignature(boolean enableSignature) {
        this.enableSignature = enableSignature;
    }

    public void setAppSign(Map<String, SignatureConfig> appSign) {
        this.appSign = appSign;
    }

    public void setNestedSign(Map<String, NestedSignatureConfig> nestedSign) {
        this.nestedSign = nestedSign;
    }

    public void setExpiredRequestMilliseconds(long expiredRequestMilliseconds) {
        this.expiredRequestMilliseconds = expiredRequestMilliseconds;
    }

    public void setEggAccessTokenExpiredSeconds(int eggAccessTokenExpiredSeconds) {
        this.eggAccessTokenExpiredSeconds = eggAccessTokenExpiredSeconds;
    }

    public void setSkipSignUrls(List<String> skipSignUrls) {
        this.skipSignUrls = skipSignUrls;
    }

    public void setSkipSignSrcApp(List<String> skipSignSrcApp) {
        this.skipSignSrcApp = skipSignSrcApp;
    }

    public void setLimitPath(List<String> limitPath) {
        this.limitPath = limitPath;
    }

    public void setOpenAuthentication(Boolean openAuthentication) {
        this.openAuthentication = openAuthentication;
    }

    public void setAccessTokenRenewSeconds(int accessTokenRenewSeconds) {
        this.accessTokenRenewSeconds = accessTokenRenewSeconds;
    }

    public void setEggSrcApp(String eggSrcApp) {
        this.eggSrcApp = eggSrcApp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SecurityProperties)) {
            return false;
        }
        SecurityProperties other = (SecurityProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getAccessTokenExpired() != other.getAccessTokenExpired()) {
            return false;
        }
        if (this.getRefreshTokenExpired() != other.getRefreshTokenExpired()) {
            return false;
        }
        if (this.getTokenRenew() != other.getTokenRenew()) {
            return false;
        }
        if (this.isEnableAuth() != other.isEnableAuth()) {
            return false;
        }
        if (this.isCheckTokenUserIdConsistency() != other.isCheckTokenUserIdConsistency()) {
            return false;
        }
        if (this.isEnableApiTimestampValidate() != other.isEnableApiTimestampValidate()) {
            return false;
        }
        if (this.isEnableSignature() != other.isEnableSignature()) {
            return false;
        }
        if (this.getExpiredRequestMilliseconds() != other.getExpiredRequestMilliseconds()) {
            return false;
        }
        if (this.getEggAccessTokenExpiredSeconds() != other.getEggAccessTokenExpiredSeconds()) {
            return false;
        }
        if (this.getAccessTokenRenewSeconds() != other.getAccessTokenRenewSeconds()) {
            return false;
        }
        Boolean this$openAuthentication = this.getOpenAuthentication();
        Boolean other$openAuthentication = other.getOpenAuthentication();
        if (this$openAuthentication == null ? other$openAuthentication != null : !((Object)this$openAuthentication).equals(other$openAuthentication)) {
            return false;
        }
        Map<String, String> this$appTokenSecret = this.getAppTokenSecret();
        Map<String, String> other$appTokenSecret = other.getAppTokenSecret();
        if (this$appTokenSecret == null ? other$appTokenSecret != null : !((Object)this$appTokenSecret).equals(other$appTokenSecret)) {
            return false;
        }
        List<String> this$checkTokenUrls = this.getCheckTokenUrls();
        List<String> other$checkTokenUrls = other.getCheckTokenUrls();
        if (this$checkTokenUrls == null ? other$checkTokenUrls != null : !((Object)this$checkTokenUrls).equals(other$checkTokenUrls)) {
            return false;
        }
        List<String> this$skipCheckTokenUrls = this.getSkipCheckTokenUrls();
        List<String> other$skipCheckTokenUrls = other.getSkipCheckTokenUrls();
        if (this$skipCheckTokenUrls == null ? other$skipCheckTokenUrls != null : !((Object)this$skipCheckTokenUrls).equals(other$skipCheckTokenUrls)) {
            return false;
        }
        Map<String, SignatureConfig> this$appSign = this.getAppSign();
        Map<String, SignatureConfig> other$appSign = other.getAppSign();
        if (this$appSign == null ? other$appSign != null : !((Object)this$appSign).equals(other$appSign)) {
            return false;
        }
        Map<String, NestedSignatureConfig> this$nestedSign = this.getNestedSign();
        Map<String, NestedSignatureConfig> other$nestedSign = other.getNestedSign();
        if (this$nestedSign == null ? other$nestedSign != null : !((Object)this$nestedSign).equals(other$nestedSign)) {
            return false;
        }
        List<String> this$skipSignUrls = this.getSkipSignUrls();
        List<String> other$skipSignUrls = other.getSkipSignUrls();
        if (this$skipSignUrls == null ? other$skipSignUrls != null : !((Object)this$skipSignUrls).equals(other$skipSignUrls)) {
            return false;
        }
        List<String> this$skipSignSrcApp = this.getSkipSignSrcApp();
        List<String> other$skipSignSrcApp = other.getSkipSignSrcApp();
        if (this$skipSignSrcApp == null ? other$skipSignSrcApp != null : !((Object)this$skipSignSrcApp).equals(other$skipSignSrcApp)) {
            return false;
        }
        List<String> this$limitPath = this.getLimitPath();
        List<String> other$limitPath = other.getLimitPath();
        if (this$limitPath == null ? other$limitPath != null : !((Object)this$limitPath).equals(other$limitPath)) {
            return false;
        }
        String this$eggSrcApp = this.getEggSrcApp();
        String other$eggSrcApp = other.getEggSrcApp();
        return !(this$eggSrcApp == null ? other$eggSrcApp != null : !this$eggSrcApp.equals(other$eggSrcApp));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SecurityProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $accessTokenExpired = this.getAccessTokenExpired();
        result = result * 59 + (int)($accessTokenExpired >>> 32 ^ $accessTokenExpired);
        long $refreshTokenExpired = this.getRefreshTokenExpired();
        result = result * 59 + (int)($refreshTokenExpired >>> 32 ^ $refreshTokenExpired);
        long $tokenRenew = this.getTokenRenew();
        result = result * 59 + (int)($tokenRenew >>> 32 ^ $tokenRenew);
        result = result * 59 + (this.isEnableAuth() ? 79 : 97);
        result = result * 59 + (this.isCheckTokenUserIdConsistency() ? 79 : 97);
        result = result * 59 + (this.isEnableApiTimestampValidate() ? 79 : 97);
        result = result * 59 + (this.isEnableSignature() ? 79 : 97);
        long $expiredRequestMilliseconds = this.getExpiredRequestMilliseconds();
        result = result * 59 + (int)($expiredRequestMilliseconds >>> 32 ^ $expiredRequestMilliseconds);
        result = result * 59 + this.getEggAccessTokenExpiredSeconds();
        result = result * 59 + this.getAccessTokenRenewSeconds();
        Boolean $openAuthentication = this.getOpenAuthentication();
        result = result * 59 + ($openAuthentication == null ? 43 : ((Object)$openAuthentication).hashCode());
        Map<String, String> $appTokenSecret = this.getAppTokenSecret();
        result = result * 59 + ($appTokenSecret == null ? 43 : ((Object)$appTokenSecret).hashCode());
        List<String> $checkTokenUrls = this.getCheckTokenUrls();
        result = result * 59 + ($checkTokenUrls == null ? 43 : ((Object)$checkTokenUrls).hashCode());
        List<String> $skipCheckTokenUrls = this.getSkipCheckTokenUrls();
        result = result * 59 + ($skipCheckTokenUrls == null ? 43 : ((Object)$skipCheckTokenUrls).hashCode());
        Map<String, SignatureConfig> $appSign = this.getAppSign();
        result = result * 59 + ($appSign == null ? 43 : ((Object)$appSign).hashCode());
        Map<String, NestedSignatureConfig> $nestedSign = this.getNestedSign();
        result = result * 59 + ($nestedSign == null ? 43 : ((Object)$nestedSign).hashCode());
        List<String> $skipSignUrls = this.getSkipSignUrls();
        result = result * 59 + ($skipSignUrls == null ? 43 : ((Object)$skipSignUrls).hashCode());
        List<String> $skipSignSrcApp = this.getSkipSignSrcApp();
        result = result * 59 + ($skipSignSrcApp == null ? 43 : ((Object)$skipSignSrcApp).hashCode());
        List<String> $limitPath = this.getLimitPath();
        result = result * 59 + ($limitPath == null ? 43 : ((Object)$limitPath).hashCode());
        String $eggSrcApp = this.getEggSrcApp();
        result = result * 59 + ($eggSrcApp == null ? 43 : $eggSrcApp.hashCode());
        return result;
    }

    public String toString() {
        return "SecurityProperties(appTokenSecret=" + this.getAppTokenSecret() + ", accessTokenExpired=" + this.getAccessTokenExpired() + ", refreshTokenExpired=" + this.getRefreshTokenExpired() + ", tokenRenew=" + this.getTokenRenew() + ", enableAuth=" + this.isEnableAuth() + ", checkTokenUserIdConsistency=" + this.isCheckTokenUserIdConsistency() + ", checkTokenUrls=" + this.getCheckTokenUrls() + ", skipCheckTokenUrls=" + this.getSkipCheckTokenUrls() + ", enableApiTimestampValidate=" + this.isEnableApiTimestampValidate() + ", enableSignature=" + this.isEnableSignature() + ", appSign=" + this.getAppSign() + ", nestedSign=" + this.getNestedSign() + ", expiredRequestMilliseconds=" + this.getExpiredRequestMilliseconds() + ", eggAccessTokenExpiredSeconds=" + this.getEggAccessTokenExpiredSeconds() + ", skipSignUrls=" + this.getSkipSignUrls() + ", skipSignSrcApp=" + this.getSkipSignSrcApp() + ", limitPath=" + this.getLimitPath() + ", openAuthentication=" + this.getOpenAuthentication() + ", accessTokenRenewSeconds=" + this.getAccessTokenRenewSeconds() + ", eggSrcApp=" + this.getEggSrcApp() + ")";
    }

    public static class NestedSignatureConfig {
        private String srcApp;
        private String nestedPlatform;
        private String secret;

        public String getSrcApp() {
            return this.srcApp;
        }

        public String getNestedPlatform() {
            return this.nestedPlatform;
        }

        public String getSecret() {
            return this.secret;
        }

        public void setSrcApp(String srcApp) {
            this.srcApp = srcApp;
        }

        public void setNestedPlatform(String nestedPlatform) {
            this.nestedPlatform = nestedPlatform;
        }

        public void setSecret(String secret) {
            this.secret = secret;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NestedSignatureConfig)) {
                return false;
            }
            NestedSignatureConfig other = (NestedSignatureConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$srcApp = this.getSrcApp();
            String other$srcApp = other.getSrcApp();
            if (this$srcApp == null ? other$srcApp != null : !this$srcApp.equals(other$srcApp)) {
                return false;
            }
            String this$nestedPlatform = this.getNestedPlatform();
            String other$nestedPlatform = other.getNestedPlatform();
            if (this$nestedPlatform == null ? other$nestedPlatform != null : !this$nestedPlatform.equals(other$nestedPlatform)) {
                return false;
            }
            String this$secret = this.getSecret();
            String other$secret = other.getSecret();
            return !(this$secret == null ? other$secret != null : !this$secret.equals(other$secret));
        }

        protected boolean canEqual(Object other) {
            return other instanceof NestedSignatureConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $srcApp = this.getSrcApp();
            result = result * 59 + ($srcApp == null ? 43 : $srcApp.hashCode());
            String $nestedPlatform = this.getNestedPlatform();
            result = result * 59 + ($nestedPlatform == null ? 43 : $nestedPlatform.hashCode());
            String $secret = this.getSecret();
            result = result * 59 + ($secret == null ? 43 : $secret.hashCode());
            return result;
        }

        public String toString() {
            return "SecurityProperties.NestedSignatureConfig(srcApp=" + this.getSrcApp() + ", nestedPlatform=" + this.getNestedPlatform() + ", secret=" + this.getSecret() + ")";
        }
    }

    public static class SignatureConfig {
        private String srcApp;
        private String platform;
        private String secret;

        public String getSrcApp() {
            return this.srcApp;
        }

        public String getPlatform() {
            return this.platform;
        }

        public String getSecret() {
            return this.secret;
        }

        public void setSrcApp(String srcApp) {
            this.srcApp = srcApp;
        }

        public void setPlatform(String platform) {
            this.platform = platform;
        }

        public void setSecret(String secret) {
            this.secret = secret;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SignatureConfig)) {
                return false;
            }
            SignatureConfig other = (SignatureConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$srcApp = this.getSrcApp();
            String other$srcApp = other.getSrcApp();
            if (this$srcApp == null ? other$srcApp != null : !this$srcApp.equals(other$srcApp)) {
                return false;
            }
            String this$platform = this.getPlatform();
            String other$platform = other.getPlatform();
            if (this$platform == null ? other$platform != null : !this$platform.equals(other$platform)) {
                return false;
            }
            String this$secret = this.getSecret();
            String other$secret = other.getSecret();
            return !(this$secret == null ? other$secret != null : !this$secret.equals(other$secret));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SignatureConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $srcApp = this.getSrcApp();
            result = result * 59 + ($srcApp == null ? 43 : $srcApp.hashCode());
            String $platform = this.getPlatform();
            result = result * 59 + ($platform == null ? 43 : $platform.hashCode());
            String $secret = this.getSecret();
            result = result * 59 + ($secret == null ? 43 : $secret.hashCode());
            return result;
        }

        public String toString() {
            return "SecurityProperties.SignatureConfig(srcApp=" + this.getSrcApp() + ", platform=" + this.getPlatform() + ", secret=" + this.getSecret() + ")";
        }
    }
}

