/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.gateway.utils;

import com.bxm.newidea.component.JSONArray;
import com.bxm.newidea.component.JSONObject;
import com.bxm.newidea.component.util.WebUtils;
import com.netflix.zuul.context.RequestContext;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMethod;

public class RequestUtils {
    private static final Logger log = LoggerFactory.getLogger(RequestUtils.class);

    private RequestUtils() {
    }

    public static String getField(HttpServletRequest request, String fieldName) {
        Map paramMap = request.getParameterMap();
        String[] fieldVal = (String[])paramMap.get(fieldName);
        if (null != fieldVal && fieldVal.length > 0) {
            return fieldVal[0];
        }
        try {
            if (RequestMethod.POST.name().equalsIgnoreCase(request.getMethod()) || RequestMethod.PUT.name().equalsIgnoreCase(request.getMethod()) || RequestMethod.DELETE.name().equalsIgnoreCase(request.getMethod())) {
                JSONObject json = JSONObject.parseObject((String)WebUtils.getRequestBodyContent((HttpServletRequest)request));
                return RequestUtils.findField(json, fieldName);
            }
        }
        catch (Exception e) {
            log.info("\u89e3\u6790\u8bf7\u6c42\u51fa\u9519,\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
        return "";
    }

    private static String findField(JSONObject json, String fieldName) {
        if (null == json) {
            return "";
        }
        Object jsonVal = json.get((Object)fieldName);
        if (null == jsonVal) {
            Collection values = json.values();
            for (Object value : values) {
                if (value instanceof JSONArray) {
                    JSONArray array = (JSONArray)value;
                    if (array.size() <= 0 || !(array.get(0) instanceof JSONObject)) continue;
                    for (int i = 0; i < array.size(); ++i) {
                        String arrayObjVal = RequestUtils.findField(array.getJSONObject(i), fieldName);
                        if (null == arrayObjVal) continue;
                        return arrayObjVal;
                    }
                    continue;
                }
                if (!(value instanceof JSONObject)) continue;
                return RequestUtils.findField((JSONObject)value, fieldName);
            }
        }
        return Objects.toString(jsonVal);
    }

    public static String getRequestField(RequestContext requestContext, String fieldName) {
        HttpServletRequest request;
        Object value = requestContext.get((Object)fieldName);
        if (null == value && null != (value = RequestUtils.getField(request = requestContext.getRequest(), fieldName))) {
            requestContext.put((Object)fieldName, value);
        }
        if (null == value) {
            return null;
        }
        return value.toString();
    }

    public static String getUserAgent(HttpServletRequest request) {
        return request.getHeader("User-Agent");
    }
}

