/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.gateway.zuul.filter.impl;

import com.bxm.component.jwt.bo.JwtTokenBO;
import com.bxm.component.jwt.util.JwtUtil;
import com.bxm.gateway.properties.SecurityProperties;
import com.bxm.gateway.utils.ApiVersionUtils;
import com.bxm.gateway.utils.RequestUtils;
import com.bxm.gateway.zuul.filter.AbstractZuulFilter;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.util.WebUtils;
import com.netflix.zuul.context.RequestContext;
import com.netflix.zuul.exception.ZuulException;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.util.AntPathMatcher;

public class AuthenticationPreFilter
extends AbstractZuulFilter {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationPreFilter.class);
    private SecurityProperties securityProperties;
    private AntPathMatcher antPathMatcher;

    public AuthenticationPreFilter(SecurityProperties securityProperties) {
        this.securityProperties = securityProperties;
        this.antPathMatcher = new AntPathMatcher();
    }

    public String filterType() {
        return "pre";
    }

    public Object run() throws ZuulException {
        if (!this.securityProperties.getOpenAuthentication().booleanValue()) {
            return null;
        }
        RequestContext requestContext = RequestContext.getCurrentContext();
        HttpServletRequest request = requestContext.getRequest();
        String uri = request.getRequestURI();
        if (this.isSecurityUri(uri)) {
            String accessToken = request.getHeader("accessToken");
            if (StringUtils.isNotBlank((CharSequence)accessToken)) {
                JwtTokenBO jwtTokenBO = this.parseToken(requestContext, accessToken);
                if (Objects.isNull(jwtTokenBO.getExpirationSeconds()) || (long)jwtTokenBO.getExpirationSeconds().intValue() * 1000L < System.currentTimeMillis()) {
                    this.logError("accessToken\u5df2\u8fc7\u671f", request);
                    throw new ZuulException("\u975e\u6cd5\u8bf7\u6c42", HttpStatus.UNAUTHORIZED.value(), "AccessToken\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\u6216\u901a\u8fc7RefreshToken\u5237\u65b0");
                }
                String userId = jwtTokenBO.getBodyWithString("userId");
                this.judgeAccessTokenExpired(jwtTokenBO, requestContext, userId);
                if (StringUtils.isNotBlank((CharSequence)userId)) {
                    this.checkTokenUserIdConsistency(requestContext, request, userId);
                }
            } else {
                log.warn("\u8bf7\u6c42\u5730\u5740[{}]\u9700\u8981\u9274\u6743\uff0c\u4f46\u662f\u8bf7\u6c42\u53c2\u6570\u4e2d\u4e0d\u5b58\u5728[token],\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)request.getRequestURI(), (Object)WebUtils.getRequestParam((HttpServletRequest)request));
                throw new ZuulException("\u975e\u6cd5\u8bf7\u6c42", HttpStatus.UNAUTHORIZED.value(), "AccessToken\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\u6216\u901a\u8fc7RefreshToken\u5237\u65b0");
            }
        }
        return null;
    }

    private void judgeAccessTokenExpired(JwtTokenBO jwtTokenBO, RequestContext requestContext, String userId) {
        Long tokenExpiredSecond;
        if (StringUtils.isBlank((CharSequence)userId)) {
            return;
        }
        String srcApp = RequestUtils.getRequestField(requestContext, "srcApp");
        if (Objects.nonNull(srcApp) && Objects.equals(srcApp, this.securityProperties.getEggSrcApp()) && (tokenExpiredSecond = Long.valueOf(((long)jwtTokenBO.getExpirationSeconds().intValue() * 1000L - System.currentTimeMillis()) / 1000L)) <= (long)this.securityProperties.getAccessTokenRenewSeconds()) {
            requestContext.set("userId", (Object)userId);
            requestContext.set("eggRenew", (Object)"renew");
            if (log.isDebugEnabled()) {
                log.debug("\u7528\u6237\uff1a{},accessToken\u8fd8\u6709{}\u79d2\u8fc7\u671f\uff0c\u9700\u8981\u81ea\u52a8\u7eed\u7ea6", (Object)userId, (Object)tokenExpiredSecond);
            }
        }
    }

    private JwtTokenBO parseToken(RequestContext requestContext, String token) throws ZuulException {
        String srcApp = RequestUtils.getRequestField(requestContext, "srcApp");
        String tokenSecret = this.securityProperties.getAppTokenSecret().get(srcApp);
        if (null == tokenSecret) {
            log.error("[{}]\u672a\u914d\u7f6e\u5bf9\u5e94\u7684\u7b7e\u540d\u5bc6\u94a5\uff0c\u8bf7\u8fdb\u884c\u914d\u7f6e", (Object)srcApp);
            throw new ZuulException("\u975e\u6cd5\u8bf7\u6c42", HttpStatus.BAD_REQUEST.value(), "\u8bf7\u6c42\u6765\u6e90\u7684\u5e94\u7528\u672a\u914d\u7f6e\u5bf9\u5e94\u7684\u8ba4\u8bc1\u5bc6\u94a5");
        }
        return JwtUtil.parseToken((String)token, (String)tokenSecret);
    }

    private void checkTokenUserIdConsistency(RequestContext requestContext, HttpServletRequest request, String userId) throws ZuulException {
        String requestUserId;
        if (this.securityProperties.isCheckTokenUserIdConsistency() && StringUtils.isNotBlank((CharSequence)(requestUserId = RequestUtils.getRequestField(requestContext, "userId"))) && !StringUtils.equals((CharSequence)requestUserId, (CharSequence)userId)) {
            this.logError("token\u4e2d\u7684userId\u4e0e\u8bf7\u6c42\u4e2d\u7684\u4e0d\u4e00\u81f4", request);
            throw new ZuulException("\u975e\u6cd5\u8bf7\u6c42", HttpStatus.FORBIDDEN.value(), "\u8bf7\u6c42\u7684Token\u4e0e\u53c2\u6570\u4e2d\u7684UserId\u4e0d\u4e00\u81f4");
        }
    }

    private boolean isSecurityUri(String uri) {
        String processUrl = ApiVersionUtils.replace(uri);
        for (String skipCheckTokenUrl : this.securityProperties.getSkipCheckTokenUrls()) {
            if (!this.antPathMatcher.match(skipCheckTokenUrl, uri)) continue;
            return false;
        }
        for (String checkTokenUrl : this.securityProperties.getCheckTokenUrls()) {
            if (!this.antPathMatcher.match(checkTokenUrl, uri)) continue;
            return true;
        }
        String[] uriComponent = StringUtils.split((String)processUrl, (String)"/");
        if (uriComponent != null) {
            for (String uriPart : uriComponent) {
                if (!"security".equals(uriPart)) continue;
                return true;
            }
        }
        return false;
    }
}

