/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.gateway.zuul.filter.impl;

import com.bxm.gateway.utils.RequestUtils;
import com.bxm.gateway.zuul.filter.AbstractZuulFilter;
import com.bxm.newidea.component.util.WebUtils;
import com.netflix.zuul.context.RequestContext;
import com.netflix.zuul.exception.ZuulException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorLogFilter
extends AbstractZuulFilter {
    private static final Logger log = LoggerFactory.getLogger(ErrorLogFilter.class);

    public String filterType() {
        return "error";
    }

    public Object run() {
        RequestContext requestContext = RequestContext.getCurrentContext();
        Throwable throwable = requestContext.getThrowable();
        HttpServletRequest request = requestContext.getRequest();
        String uri = request.getRequestURI();
        if (throwable instanceof ZuulException) {
            this.logError("\u8bf7\u6c42\u4e0d\u5408\u6cd5", request);
        } else {
            log.error("\u8bf7\u6c42\u51fa\u9519\uff0curi:{}, param:{},UA:{}", new Object[]{uri, WebUtils.getRequestParam((HttpServletRequest)request), RequestUtils.getUserAgent(request), throwable});
        }
        return null;
    }

    @Override
    public int filterOrder() {
        return super.filterOrder();
    }
}

