/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.gateway.zuul.filter.impl;

import com.bxm.gateway.constant.GatewayConstant;
import com.bxm.gateway.properties.GatewayProperties;
import com.bxm.gateway.properties.SecurityProperties;
import com.bxm.gateway.utils.RequestUtils;
import com.bxm.gateway.zuul.filter.AbstractZuulFilter;
import com.bxm.newidea.component.util.WebUtils;
import com.netflix.zuul.context.RequestContext;
import com.netflix.zuul.exception.ZuulException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.CollectionUtils;

public class LimitPathPreFilter
extends AbstractZuulFilter {
    private static final Logger log = LoggerFactory.getLogger(LimitPathPreFilter.class);
    private final SecurityProperties securityProperties;
    private final GatewayProperties gatewayProperties;
    private AntPathMatcher antPathMatcher;

    public LimitPathPreFilter(SecurityProperties securityProperties, GatewayProperties gatewayProperties) {
        this.securityProperties = securityProperties;
        this.gatewayProperties = gatewayProperties;
        this.antPathMatcher = new AntPathMatcher();
    }

    public String filterType() {
        return "pre";
    }

    public Object run() throws ZuulException {
        RequestContext requestContext = RequestContext.getCurrentContext();
        HttpServletRequest request = requestContext.getRequest();
        String uri = request.getRequestURI();
        this.accessLog(request);
        List<String> limitPathList = this.securityProperties.getLimitPath();
        if (!CollectionUtils.isEmpty(limitPathList)) {
            for (String limitPath : limitPathList) {
                if (!this.antPathMatcher.match(limitPath, uri)) continue;
                throw new ZuulException("\u975e\u6cd5\u8bf7\u6c42", HttpStatus.UNAUTHORIZED.value(), "\u65e0\u6743\u9650\u8bbf\u95ee\u7684api\u8def\u5f84");
            }
        }
        return null;
    }

    private void accessLog(HttpServletRequest request) {
        String requestMethod = request.getMethod();
        if (HttpMethod.OPTIONS.matches(requestMethod)) {
            return;
        }
        String url = request.getRequestURI();
        for (String ignoreAccessLogUrl : this.gatewayProperties.getIgnoreAccessLogUrls()) {
            if (!this.antPathMatcher.match(ignoreAccessLogUrl, url)) continue;
            return;
        }
        String requestIp = WebUtils.getIpAddr((HttpServletRequest)request);
        String params = WebUtils.getRequestParam((HttpServletRequest)request);
        log.info(GatewayConstant.ACCESS, "[{}][{}][{}][{}][{}]", new Object[]{requestMethod, RequestUtils.getUserAgent(request), requestIp, url, params});
    }

    @Override
    public int filterOrder() {
        return super.filterOrder();
    }
}

