/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.gateway.zuul.filter.impl;

import com.bxm.gateway.properties.SecurityProperties;
import com.bxm.gateway.utils.ApiVersionUtils;
import com.bxm.gateway.utils.RequestUtils;
import com.bxm.gateway.zuul.filter.AbstractZuulFilter;
import com.bxm.newidea.component.tools.MD5Util;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.util.WebUtils;
import com.netflix.zuul.context.RequestContext;
import com.netflix.zuul.exception.ZuulException;
import java.util.Arrays;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.bind.annotation.RequestMethod;

public class SignaturePreFilter
extends AbstractZuulFilter {
    private static final Logger log = LoggerFactory.getLogger(SignaturePreFilter.class);
    private SecurityProperties securityProperties;
    private AntPathMatcher antPathMatcher;

    public SignaturePreFilter(SecurityProperties securityProperties) {
        this.securityProperties = securityProperties;
        this.antPathMatcher = new AntPathMatcher();
    }

    public String filterType() {
        return "pre";
    }

    public Object run() throws ZuulException {
        if (!this.securityProperties.isEnableSignature()) {
            return null;
        }
        RequestContext requestContext = RequestContext.getCurrentContext();
        HttpServletRequest request = requestContext.getRequest();
        String uri = request.getRequestURI();
        try {
            String srcApp = RequestUtils.getRequestField(requestContext, "srcApp");
            if (this.matchUrl(uri, srcApp)) {
                this.validSignature(requestContext, request, uri);
            }
        }
        catch (ZuulException e) {
            throw e;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ZuulException("\u975e\u6cd5\u8bf7\u6c42", HttpStatus.BAD_REQUEST.value(), "\u672a\u77e5\u9519\u8bef");
        }
        return null;
    }

    private void validSignature(RequestContext requestContext, HttpServletRequest request, String url) throws ZuulException {
        String requestApiSign = this.getSignStr(request);
        String actual = request.getParameter("sign");
        String secret = this.getSecret(requestContext, request, url);
        String expect = MD5Util.standardMd5((String)(requestApiSign + secret));
        if (StringUtils.notEquals((CharSequence)expect, (CharSequence)actual)) {
            log.error("\u7b7e\u540d\u9519\u8bef\uff0cexpect:[{}],actual:[{}],origin:[{}],secret:[{}]", new Object[]{expect, actual, requestApiSign, secret});
            this.logError("\u7b7e\u540d\u6821\u9a8c\u9519\u8bef", request);
            throw new ZuulException("\u975e\u6cd5\u8bf7\u6c42", HttpStatus.BAD_REQUEST.value(), "\u7b7e\u540d\u6821\u9a8c\u5931\u8d25");
        }
    }

    private String getSecret(RequestContext requestContext, HttpServletRequest request, String url) throws ZuulException {
        String srcApp = RequestUtils.getRequestField(requestContext, "srcApp");
        String platform = RequestUtils.getRequestField(requestContext, "platform");
        String nestedPlatform = RequestUtils.getRequestField(requestContext, "nestedPlatform");
        if (null == srcApp || null == platform) {
            log.error("\u8bf7\u6c42[{}]\u9700\u8981\u8fdb\u884c\u7b7e\u540d\u8ba4\u8bc1\uff0c\u4f46\u662f\u672a\u4f20\u9012srcApp\u6216platform\u53c2\u6570\uff0c\u5b8c\u6574\u53c2\u6570\uff1a{}", (Object)url, (Object)WebUtils.getRequestParam((HttpServletRequest)request));
            throw new ZuulException("\u975e\u6cd5\u8bf7\u6c42", HttpStatus.BAD_REQUEST.value(), "\u8bf7\u6c42\u4e2d\u4e0d\u5305\u542b\u5e94\u7528\u6765\u6e90\u4fe1\u606f\u548c\u5e73\u53f0\u53c2\u6570");
        }
        if (StringUtils.isNotBlank((CharSequence)nestedPlatform) && !"null".equals(nestedPlatform)) {
            return this.getNestedSecret(srcApp, platform, nestedPlatform);
        }
        for (SecurityProperties.SignatureConfig signatureConfig : this.securityProperties.getAppSign().values()) {
            if (!StringUtils.equals((CharSequence)signatureConfig.getSrcApp(), (CharSequence)srcApp) || !StringUtils.equals((CharSequence)signatureConfig.getPlatform(), (CharSequence)platform)) continue;
            return signatureConfig.getSecret();
        }
        log.error("[{}][{}]\u672a\u914d\u7f6e\u5bf9\u5e94\u7684\u7b7e\u540d\u5bc6\u94a5\uff0c\u8bf7\u8fdb\u884c\u914d\u7f6e", (Object)srcApp, (Object)platform);
        throw new ZuulException("\u975e\u6cd5\u8bf7\u6c42", HttpStatus.BAD_REQUEST.value(), "\u8bf7\u6c42\u6765\u6e90\u7684\u5e94\u7528\u672a\u914d\u7f6e\u5bf9\u5e94\u7684\u7b7e\u540d\u5bc6\u94a5");
    }

    private String getNestedSecret(String srcApp, String platform, String nestedPlatform) throws ZuulException {
        for (SecurityProperties.NestedSignatureConfig nestedSignatureConfig : this.securityProperties.getNestedSign().values()) {
            if (!StringUtils.equals((CharSequence)nestedSignatureConfig.getSrcApp(), (CharSequence)srcApp) || !StringUtils.equals((CharSequence)nestedSignatureConfig.getNestedPlatform(), (CharSequence)nestedPlatform)) continue;
            return nestedSignatureConfig.getSecret();
        }
        log.error("\u524d\u7aef\u8bf7\u6c42,srcApp\uff1a[{}]\uff0c \u5e73\u53f0\u7c7b\u578b\uff1a[{}]\uff0c\u5185\u5d4c\u5e73\u53f0\u7c7b\u578b: [{}],\u672a\u914d\u7f6e\u5bf9\u5e94\u7684\u7b7e\u540d\u5bc6\u94a5\uff0c\u8bf7\u8fdb\u884c\u914d\u7f6e", new Object[]{srcApp, platform, nestedPlatform});
        throw new ZuulException("\u975e\u6cd5\u8bf7\u6c42", HttpStatus.BAD_REQUEST.value(), "\u8bf7\u6c42\u6765\u6e90\u7684\u5e94\u7528h5\u672a\u914d\u7f6e\u5bf9\u5e94\u7684\u7b7e\u540d\u5bc6\u94a5");
    }

    private String getSignStr(HttpServletRequest request) {
        String requestBody;
        String paramStr = RequestMethod.POST.name().equals(request.getMethod()) || RequestMethod.PUT.name().equals(request.getMethod()) || RequestMethod.DELETE.name().equals(request.getMethod()) ? ("".equals(requestBody = WebUtils.getRequestBodyContent((HttpServletRequest)request)) ? this.getParamMap(request) : requestBody) : this.getParamMap(request);
        return paramStr;
    }

    private String getParamMap(HttpServletRequest request) {
        Map paramMap = request.getParameterMap();
        StringBuilder param = new StringBuilder();
        Object[] keyArr = paramMap.keySet().toArray(new String[0]);
        Arrays.sort(keyArr);
        for (Object key : keyArr) {
            String[] valueArray;
            if (!StringUtils.isNotEmpty((CharSequence)key) || "sign".equals(key)) continue;
            for (String value : valueArray = (String[])paramMap.get(key)) {
                param.append((String)key).append("=").append(value);
            }
        }
        return param.toString();
    }

    private boolean matchUrl(String uri, String srcApp) {
        String finalUrl = ApiVersionUtils.replace(uri);
        for (String urlPatter : this.securityProperties.getSkipSignUrls()) {
            if (!this.antPathMatcher.match(urlPatter, finalUrl)) continue;
            return false;
        }
        return !this.securityProperties.getSkipSignSrcApp().contains(srcApp);
    }
}

