/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.gateway.zuul.filter.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.egg.user.facade.bo.UserTokenBO;
import com.bxm.gateway.integration.EggTokenIntegrationService;
import com.bxm.gateway.properties.GatewayProperties;
import com.bxm.gateway.properties.SecurityProperties;
import com.bxm.gateway.utils.RequestUtils;
import com.bxm.gateway.zuul.filter.AbstractZuulFilter;
import com.bxm.newidea.component.tools.StringUtils;
import com.netflix.zuul.context.RequestContext;
import com.netflix.zuul.exception.ZuulException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenRenewPostFilter
extends AbstractZuulFilter {
    private static final Logger log = LoggerFactory.getLogger(TokenRenewPostFilter.class);
    private SecurityProperties securityProperties;
    private GatewayProperties gatewayProperties;
    private EggTokenIntegrationService eggTokenIntegrationService;

    public TokenRenewPostFilter(SecurityProperties securityProperties, GatewayProperties gatewayProperties, EggTokenIntegrationService eggTokenIntegrationService) {
        this.securityProperties = securityProperties;
        this.gatewayProperties = gatewayProperties;
        this.eggTokenIntegrationService = eggTokenIntegrationService;
    }

    public String filterType() {
        return "post";
    }

    public Object run() throws ZuulException {
        RequestContext requestContext = RequestContext.getCurrentContext();
        String srcApp = RequestUtils.getRequestField(requestContext, "srcApp");
        String userId = RequestUtils.getRequestField(requestContext, "userId");
        String eggRenewTokenFlag = RequestUtils.getRequestField(requestContext, "eggRenew");
        if (Objects.nonNull(srcApp) && Objects.equals(srcApp, this.securityProperties.getEggSrcApp()) && StringUtils.isNotBlank((CharSequence)eggRenewTokenFlag) && eggRenewTokenFlag.equals("renew") && StringUtils.isNotBlank((CharSequence)userId)) {
            UserTokenBO userTokenBO = this.eggTokenIntegrationService.renewToken(Long.valueOf(userId));
            if (log.isDebugEnabled()) {
                log.debug("\u7528\u6237\uff1a{},\u91cd\u65b0\u7eed\u7ea6\u751f\u6210accessToken\uff1a{}", (Object)userId, (Object)JSON.toJSONString((Object)userTokenBO));
            }
            if (userTokenBO != null) {
                requestContext.getResponse().setHeader("renew-access-token", userTokenBO.getReNewAccessToken());
                requestContext.getResponse().setHeader("renew-refresh-token", userTokenBO.getReNewRefreshToken());
            }
        }
        return null;
    }
}

