/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.gateway.zuul.filter.impl;

import com.bxm.gateway.properties.SecurityProperties;
import com.bxm.gateway.utils.RequestUtils;
import com.bxm.gateway.zuul.filter.AbstractZuulFilter;
import com.bxm.newidea.component.util.WebUtils;
import com.netflix.zuul.context.RequestContext;
import com.netflix.zuul.exception.ZuulException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

public class ValidateTimestampPreFilter
extends AbstractZuulFilter {
    private static final Logger log = LoggerFactory.getLogger(ValidateTimestampPreFilter.class);
    private SecurityProperties securityProperties;

    public ValidateTimestampPreFilter(SecurityProperties securityProperties) {
        this.securityProperties = securityProperties;
    }

    public String filterType() {
        return "pre";
    }

    public Object run() throws ZuulException {
        if (this.securityProperties.isEnableApiTimestampValidate()) {
            RequestContext requestContext = RequestContext.getCurrentContext();
            HttpServletRequest request = requestContext.getRequest();
            String cliTime = RequestUtils.getRequestField(requestContext, "cliTime");
            if (NumberUtils.isDigits((String)cliTime)) {
                long deviateVal = Math.abs(Long.valueOf(cliTime) - System.currentTimeMillis());
                if (deviateVal > this.securityProperties.getExpiredRequestMilliseconds()) {
                    log.error("\u8bf7\u6c42\u65f6\u95f4\u6233\u9519\u8bef,\u8bf7\u6c42IP\uff1a[{}]\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a[{}],\u504f\u5dee\u503c\uff1a[{}]\uff0cUA:[{}]", new Object[]{WebUtils.getIpAddr((HttpServletRequest)request), WebUtils.getRequestParam((HttpServletRequest)request), deviateVal, RequestUtils.getUserAgent(request)});
                    throw new ZuulException("\u975e\u6cd5\u8bf7\u6c42", HttpStatus.BAD_REQUEST.value(), "\u8bf7\u6c42\u65f6\u95f4\u4e0d\u5728\u5408\u6cd5\u8303\u56f4");
                }
            } else if (null != cliTime) {
                this.logError("\u8bf7\u6c42\u4e2d\u7684cliTime\u4e0d\u662f\u4e00\u4e2a\u6709\u6548\u7684\u65f6\u95f4\u683c\u5f0f", request);
            } else {
                this.logInfo("\u8bf7\u6c42\u672a\u63d0\u4f9b\u65f6\u95f4\u6233", request);
            }
        }
        return null;
    }
}

