/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.gateway.zuul.route;

import com.bxm.gateway.utils.ApiVersionUtils;
import org.springframework.cloud.netflix.zuul.filters.RefreshableRouteLocator;
import org.springframework.cloud.netflix.zuul.filters.Route;
import org.springframework.cloud.netflix.zuul.filters.SimpleRouteLocator;
import org.springframework.cloud.netflix.zuul.filters.ZuulProperties;

public class DynamicRouteLocator
extends SimpleRouteLocator
implements RefreshableRouteLocator {
    public DynamicRouteLocator(String servletPath, ZuulProperties properties) {
        super(servletPath, properties);
    }

    public Route getMatchingRoute(String path) {
        boolean hasVersion = ApiVersionUtils.hasPrefix(path);
        if (hasVersion) {
            Route route = super.getMatchingRoute(ApiVersionUtils.replace(path));
            route.setPath(path);
            route.setFullPath(path);
            return route;
        }
        return super.getMatchingRoute(path);
    }

    public void refresh() {
        this.doRefresh();
    }
}

