package com.bxm.thirdparty.grant.facade.enums;

/**
 * 授权账号类型
 *
 * @author liujia
 * @date 7/6/21 8:30 PM
 **/
public enum AccountTypeEnum {
    /**
     * 支付宝
     */
    ALIPAY(1),

    /**
     * 微信公众号
     */
    WECHAT_MP(2),

    /**
     * 微信app
     */
    WECHAT_APP(3),

    /**
     * 北京银联支付
     */
    UMS(4),
    ;

    private int code;

    AccountTypeEnum(int code) {
        this.code = code;
    }

    public int getCode() {
        return code;
    }

    public static AccountTypeEnum get(int code) {
        for (AccountTypeEnum statusEnum : AccountTypeEnum.values()) {
            if (statusEnum.getCode() == code) {
                return statusEnum;
            }
        }

        return null;
    }

    public boolean equalsCode(int code) {
        return this.getCode() == code;
    }
}
