package com.bxm.thirdparty.api.controller;

import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.util.WebUtils;
import com.bxm.newidea.component.vo.ResponseJson;
import com.bxm.thirdparty.platform.constant.CommonConstant;
import com.bxm.thirdparty.platform.facade.request.*;
import com.bxm.thirdparty.platform.facade.response.*;
import com.bxm.thirdparty.platform.service.ThirdPartyPlatformService;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;

/**
 * @author lowi
 * @date 2023/3/9 9:37
 */
@RequestMapping("{version}/3rd/platform")
@RestController
@Slf4j
public class ThirdPartyPlatformController {

    @Resource
    private ThirdPartyPlatformService thirdPartyPlatformService;

    @ApiOperation("3-02-3 [v1]发起预支付")
    @PostMapping("payment/pre")
    @ApiVersion(1)
    public ResponseJson<PrePaymentResponse> prePayment(@Valid @RequestBody PaymentPreRequest param,
                                                       HttpServletRequest request) {
        log.info("业务方发起预支付：{}", param);
        param.setRequestIp(WebUtils.getIpAddr(request));
        Message message = thirdPartyPlatformService.execPlatformHandler(param);
        if (message.isSuccess()) {
            PrePaymentResponse response = message.getParam(CommonConstant.RESULT_DTO);
            return ResponseJson.ok(response);
        }
        return ResponseJson.build(message);
    }

    @ApiOperation("3-02-3 [v1]发起话费充值")
    @PostMapping("phone/topUp")
    @ApiVersion(1)
    public ResponseJson<ChargePhoneTopUpResponse> chargePhoneTopUp(@Valid @RequestBody ChargePhoneRequest param,
                                                                   HttpServletRequest request) {
        log.info("业务方发起话费充值：{}", param);
        Message message = thirdPartyPlatformService.execPlatformHandler(param);
        if (message.isSuccess()) {
            ChargePhoneTopUpResponse response = message.getParam(CommonConstant.RESULT_DTO);
            return ResponseJson.ok(response);
        }
        return ResponseJson.build(message);
    }

    @ApiOperation("3-02-3 [v1]发起电费充值")
    @PostMapping("electric/topUp")
    @ApiVersion(1)
    public ResponseJson<ElectricTopUpResponse> electricTopUp(@Valid @RequestBody ElectricRequest param,
                                                             HttpServletRequest request) {
        log.info("业务方发起电费充值：{}", param);
        Message message = thirdPartyPlatformService.execPlatformHandler(param);
        if (message.isSuccess()) {
            ElectricTopUpResponse response = message.getParam(CommonConstant.RESULT_DTO);
            return ResponseJson.ok(response);
        }
        return ResponseJson.build(message);
    }

    @ApiOperation("3-02-3 [v1]发起退款")
    @PostMapping("payment/refund")
    @ApiVersion(1)
    public ResponseJson<RefundResponse> prePayment(@Valid @RequestBody PaymentRefundRequest param,
                                                   HttpServletRequest request) {
        log.info("业务方发起退款：{}", param);
        param.setRequestIp(WebUtils.getIpAddr(request));
        Message message = thirdPartyPlatformService.execPlatformHandler(param);
        if (message.isSuccess()) {
            RefundResponse response = message.getParam(CommonConstant.RESULT_DTO);
            return ResponseJson.ok(response);
        }
        return ResponseJson.build(message);
    }

    @ApiOperation("3-02-3 [v1]发起提现")
    @PostMapping("payment/withdraw")
    @ApiVersion(1)
    public ResponseJson<WithdrawResponse> prePayment(@Valid @RequestBody WithdrawRequest param,
                                                     HttpServletRequest request) {
        log.info("业务方发起提现：{}", param);
        param.setRequestIp(WebUtils.getIpAddr(request));
        Message message = thirdPartyPlatformService.execPlatformHandler(param);
        if (message.isSuccess()) {
            WithdrawResponse response = message.getParam(CommonConstant.RESULT_DTO);
            return ResponseJson.ok(response);
        }
        return ResponseJson.build(message);
    }
}


