package com.bxm.thirdparty.api.register;

import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.vo.ResponseJson;
import com.bxm.thirdparty.platform.facade.request.RegisterNotifyParam;
import com.bxm.thirdparty.platform.service.ApplicationRelationService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * @author lowi
 * @date 2023/3/31 16:37
 */
@Api(tags = "3-02 发起预支付请求")
@RestController
@RequestMapping("{version}/3rd/register")
@Slf4j
public class RegisterController {

    @Resource
    private ApplicationRelationService applicationRelationService;

    @ApiOperation(value = "3-02-1 [v1]注册通知")
    @PostMapping("notify")
    @ApiVersion(1)
    public ResponseJson<Boolean> registerNotify(@RequestBody RegisterNotifyParam param) {
        log.info("业务方注册到本服务：{}", param);
        return ResponseJson.ok(applicationRelationService.registerNotify(param));
    }
}
