package com.bxm.thirdparty.api.thirdparty;

import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.vo.ResponseJson;
import com.bxm.thirdparty.platform.service.PaymentAccountBalanceService;
import com.bxm.thirdparty.platform.service.ThirdPartyFailService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.math.BigDecimal;

/**
 * @author lowi
 * @date 2023/2/1 14:41
 */
@Api(tags = "19-06 第三方回调接口")
@RestController
@RequestMapping("{version}/3rd/public")
@Slf4j
public class PublicPlatformController {

    @Resource
    private PaymentAccountBalanceService paymentAccountBalanceService;

    @Resource
    private ThirdPartyFailService thirdPartyFailService;

    @ApiOperation(value = "3-03-1 账户充值", notes = "第三方提现需要账户有余额，此接口用户提醒账户提现余额")
    @GetMapping(value = "account/recharge")
    @ApiVersion(1)
    public ResponseJson<Boolean> addMoney(@RequestParam("accountId") String accountId, @RequestParam("money") BigDecimal money) {
        paymentAccountBalanceService.addMoney(accountId, money);
        return ResponseJson.ok(Boolean.TRUE);
    }


    @ApiOperation(value = "3-03-1 平台重试", notes = "当程序处理已经不再处理，人工接入处理")
    @GetMapping(value = "platform/retry")
    @ApiVersion(1)
    public ResponseJson<Boolean> platformRetry() {
        thirdPartyFailService.platformRetry();
        return ResponseJson.ok(Boolean.TRUE);
    }

}
