package com.bxm.thirdparty.api.thirdparty;

import cn.hutool.http.HttpUtil;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.JSONObject;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.util.WebUtils;
import com.bxm.thirdparty.platform.callback.param.*;
import com.bxm.thirdparty.platform.service.ThirdPartyCallbackService;
import com.github.binarywang.wxpay.bean.notify.WxPayNotifyResponse;
import com.google.common.collect.Maps;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;

/**
 * @author lowi
 * @date 2023/2/1 14:41
 */
@Api(tags = "19-06 第三方回调接口")
@RestController
@RequestMapping("{version}/3rd/public/callback")
@Slf4j
public class ThirdPartyCallbackController {

    @Resource
    private ThirdPartyCallbackService thirdPartyCallbackService;

    @ApiOperation(value = "3-03-1 支付宝交易回调", httpMethod = "GET")
    @RequestMapping(value = "alipay/trade")
    @ApiVersion(1)
    public void alipayTrade(HttpServletRequest request, HttpServletResponse response) {
        String bodyContent = WebUtils.getRequestBodyContent(request);
        Map<String, String> paramMap = covertMap(request);
        paramMap.putAll(HttpUtil.decodeParamMap(bodyContent, StandardCharsets.UTF_8));

        log.info("支付宝回调参数: {},body:{}", paramMap, WebUtils.getRequestBodyContent(request));
        AlipayPaymentCallbackParam requestBody = parseRequest(paramMap);
        try {
            Message message = thirdPartyCallbackService.execAlipayTradeCallback(requestBody);
            if (message.isSuccess()) {
                response.getWriter().print("success");
            } else {
                log.info("支付宝回调处理失败，请求参数：{}", requestBody);
                response.getWriter().print("fail");
            }
        } catch (IOException e) {
            log.error("response获取writer异常:{}", e.getMessage(), e);
        }
    }

    @ApiOperation("3-03-2 微信交易回调")
    @PostMapping("wechat/trade/{mchId}/{paymentOrderNo}")
    @ApiVersion(1)
    public String wechatTrade(@PathVariable String mchId,
                              @PathVariable String paymentOrderNo,
                              @RequestBody String xmlData) {
        log.info("收到微信支付回调：{}", xmlData);
        WxPaymentCallbackParam wxPaymentCallbackParam = new WxPaymentCallbackParam();
        wxPaymentCallbackParam.setPaymentOrderNo(paymentOrderNo);
        wxPaymentCallbackParam.setMchId(mchId);
        wxPaymentCallbackParam.setXmlData(xmlData);
        Message message = thirdPartyCallbackService.executeWechatCallback(wxPaymentCallbackParam);
        if (message.isSuccess()) {
            return WxPayNotifyResponse.success("SUCCESS");
        }
        return WxPayNotifyResponse.fail("FAIL");
    }

    private Map<String, String> covertMap(HttpServletRequest request) {
        Map<String, String> map = Maps.newHashMap();
        Map<String, String[]> requestParams = request.getParameterMap();
        for (Iterator<String> iter = requestParams.keySet().iterator(); iter.hasNext(); ) {
            String name = iter.next();
            String[] values = requestParams.get(name);
            String valueStr = "";
            for (int i = 0; i < values.length; i++) {
                valueStr = (i == values.length - 1) ? valueStr + values[i]
                        : valueStr + values[i] + ",";
            }
            map.put(name, valueStr);
        }

        log.info("异步通知返回信息：{}", JSONObject.toJSONString(map));
        return map;
    }

    private AlipayPaymentCallbackParam parseRequest(Map<String, String> paramMap) {
        AlipayPaymentCallbackParam callbackRequest = new AlipayPaymentCallbackParam();

        callbackRequest.setOutTradeNo(paramMap.get("out_trade_no"));
        callbackRequest.setTradeNo(paramMap.get("trade_no"));
        callbackRequest.setTradeStatus(paramMap.get("trade_status"));
        callbackRequest.setAppId(paramMap.get("app_id"));
        callbackRequest.setSignType(paramMap.get("sign_type"));

        String notifyTimeStr = paramMap.get("notify_time");
        if (StringUtils.isNotBlank(notifyTimeStr)) {
            callbackRequest.setNotifyTime(DateUtils.parseDateTime(notifyTimeStr));
        }

        return callbackRequest;
    }

    @ApiOperation(value = "3-03-1 心融交易回调")
    @GetMapping(value = "xinrong")
    @ApiVersion(1)
    public void xinrong(XinRongChargePhoneParam param, HttpServletResponse response) {
        log.info("心融充值话费回调接口回调参数：{}", param);
        try {
            Message message = thirdPartyCallbackService.execXinrongCallback(param);
            if (message.isSuccess()) {
                response.getWriter().print("SUCCESS");
            }
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
    }

    @ApiOperation(value = "3-03-1 支付宝交易回调", httpMethod = "GET")
    @PostMapping(value = "liba")
    @ApiVersion(1)
    public void liba(@RequestBody String param, HttpServletResponse response) {
        log.info("liba充值电费回调接口回调参数：{}", param);
        if (StringUtils.isBlank(param)) {
            return;
        }
        LiBaCallbackParam liBaCallbackParam = JSON.parseObject(param, LiBaCallbackParam.class);
        try {
            Message message = thirdPartyCallbackService.execLiBaCallback(liBaCallbackParam);
            if(message.isSuccess()){
                response.getWriter().print("SUCCESS");
            }
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
    }

    @ApiOperation("3-03-3 微信退款回调")
    @PostMapping("wechat/refund/{mchId}/{refundOrderNo}")
    @ApiVersion(1)
    public String wechatRefund(@PathVariable String mchId,
                               @PathVariable String refundOrderNo,
                               @RequestBody String xmlData) {
        log.info("微信退款回调回调参数mchId:{},refundOrderNo:{},xmlData：{}", mchId, refundOrderNo, xmlData);
        WxRefundCallbackParam wxRefundCallbackParam = new WxRefundCallbackParam();
        wxRefundCallbackParam.setMchId(mchId);
        wxRefundCallbackParam.setRefundOrderNo(refundOrderNo);
        wxRefundCallbackParam.setXmlData(xmlData);
        Message message = thirdPartyCallbackService.execWechatRefund(wxRefundCallbackParam);
        if (message.isSuccess()) {
            return WxPayNotifyResponse.success("SUCCESS");
        } else {
            return WxPayNotifyResponse.success("FAIL");
        }
    }

}
