/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.thirdparty.api.thirdparty;

import cn.hutool.http.HttpUtil;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.JSONObject;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.util.WebUtils;
import com.bxm.thirdparty.platform.callback.param.AlipayPaymentCallbackParam;
import com.bxm.thirdparty.platform.callback.param.GongMaoCallbackParam;
import com.bxm.thirdparty.platform.callback.param.LiBaCallbackParam;
import com.bxm.thirdparty.platform.callback.param.WxPaymentCallbackParam;
import com.bxm.thirdparty.platform.callback.param.WxRefundCallbackParam;
import com.bxm.thirdparty.platform.callback.param.XinRongChargePhoneParam;
import com.bxm.thirdparty.platform.enums.PlatformBusinessTypeEnum;
import com.bxm.thirdparty.platform.service.ThirdPartyCallbackService;
import com.github.binarywang.wxpay.bean.notify.WxPayNotifyResponse;
import com.google.common.collect.Maps;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"19-06 \u7b2c\u4e09\u65b9\u56de\u8c03\u63a5\u53e3"})
@RestController
@RequestMapping(value={"{version}/3rd/public/callback"})
public class ThirdPartyCallbackController {
    private static final Logger log = LoggerFactory.getLogger(ThirdPartyCallbackController.class);
    @Resource
    private ThirdPartyCallbackService thirdPartyCallbackService;

    @ApiOperation(value="3-03-1 \u652f\u4ed8\u5b9d\u4ea4\u6613\u56de\u8c03", httpMethod="GET")
    @RequestMapping(value={"alipay/trade"})
    @ApiVersion(value=1)
    public void alipayTrade(HttpServletRequest request, HttpServletResponse response) {
        String bodyContent = WebUtils.getRequestBodyContent((HttpServletRequest)request);
        Map<String, String> paramMap = this.covertMap(request);
        paramMap.putAll(HttpUtil.decodeParamMap((String)bodyContent, (Charset)StandardCharsets.UTF_8));
        log.info("\u652f\u4ed8\u5b9d\u56de\u8c03\u53c2\u6570: {},body:{}", paramMap, (Object)WebUtils.getRequestBodyContent((HttpServletRequest)request));
        AlipayPaymentCallbackParam requestBody = this.parseRequest(paramMap);
        try {
            Message message = this.thirdPartyCallbackService.execAlipayTradeCallback(requestBody);
            if (message.isSuccess()) {
                response.getWriter().print("success");
            } else {
                log.info("\u652f\u4ed8\u5b9d\u56de\u8c03\u5904\u7406\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)requestBody);
                response.getWriter().print("fail");
            }
        }
        catch (IOException e) {
            log.error("response\u83b7\u53d6writer\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
        }
    }

    @ApiOperation(value="3-03-2 \u5fae\u4fe1\u4ea4\u6613\u56de\u8c03")
    @PostMapping(value={"wechat/trade/{mchId}/{paymentOrderNo}"})
    @ApiVersion(value=1)
    public String wechatTrade(@PathVariable String mchId, @PathVariable String paymentOrderNo, @RequestBody String xmlData) {
        log.info("\u6536\u5230\u5fae\u4fe1\u652f\u4ed8\u56de\u8c03\uff1a{}", (Object)xmlData);
        WxPaymentCallbackParam wxPaymentCallbackParam = new WxPaymentCallbackParam();
        wxPaymentCallbackParam.setPaymentOrderNo(paymentOrderNo);
        wxPaymentCallbackParam.setMchId(mchId);
        wxPaymentCallbackParam.setXmlData(xmlData);
        Message message = this.thirdPartyCallbackService.executeWechatCallback(wxPaymentCallbackParam);
        if (message.isSuccess()) {
            return WxPayNotifyResponse.success((String)"SUCCESS");
        }
        return WxPayNotifyResponse.fail((String)"FAIL");
    }

    private Map<String, String> covertMap(HttpServletRequest request) {
        HashMap map = Maps.newHashMap();
        Map requestParams = request.getParameterMap();
        for (String name : requestParams.keySet()) {
            String[] values = (String[])requestParams.get(name);
            String valueStr = "";
            for (int i = 0; i < values.length; ++i) {
                valueStr = i == values.length - 1 ? valueStr + values[i] : valueStr + values[i] + ",";
            }
            map.put(name, valueStr);
        }
        log.info("\u5f02\u6b65\u901a\u77e5\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)map));
        return map;
    }

    private AlipayPaymentCallbackParam parseRequest(Map<String, String> paramMap) {
        AlipayPaymentCallbackParam callbackRequest = new AlipayPaymentCallbackParam();
        callbackRequest.setOutTradeNo(paramMap.get("out_trade_no"));
        callbackRequest.setTradeNo(paramMap.get("trade_no"));
        callbackRequest.setTradeStatus(paramMap.get("trade_status"));
        callbackRequest.setAppId(paramMap.get("app_id"));
        callbackRequest.setSignType(paramMap.get("sign_type"));
        String notifyTimeStr = paramMap.get("notify_time");
        if (StringUtils.isNotBlank((CharSequence)notifyTimeStr)) {
            callbackRequest.setNotifyTime(DateUtils.parseDateTime((String)notifyTimeStr));
        }
        return callbackRequest;
    }

    @ApiOperation(value="3-03-1 \u5fc3\u878d\u4ea4\u6613\u56de\u8c03")
    @RequestMapping(value={"xinrong"})
    @ApiVersion(value=1)
    public void xinrong(XinRongChargePhoneParam param, HttpServletResponse response) {
        log.info("\u5fc3\u878d\u5145\u503c\u8bdd\u8d39\u56de\u8c03\u63a5\u53e3\u56de\u8c03\u53c2\u6570\uff1a{}", (Object)param);
        try {
            Message message = this.thirdPartyCallbackService.execXinrongCallback(param);
            if (message.isSuccess()) {
                response.getWriter().print("SUCCESS");
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @ApiOperation(value="3-03-1 \u652f\u4ed8\u5b9d\u4ea4\u6613\u56de\u8c03", httpMethod="GET")
    @PostMapping(value={"liba"})
    @ApiVersion(value=1)
    public void liba(@RequestBody String param, HttpServletResponse response) {
        log.info("liba\u5145\u503c\u7535\u8d39\u56de\u8c03\u63a5\u53e3\u56de\u8c03\u53c2\u6570\uff1a{}", (Object)param);
        Map map = HttpUtil.decodeParamMap((String)param, (Charset)StandardCharsets.UTF_8);
        LiBaCallbackParam liBaCallbackParam = (LiBaCallbackParam)JSON.parseObject((String)JSON.toJSONString((Object)map), LiBaCallbackParam.class);
        try {
            Message message = this.thirdPartyCallbackService.execLiBaCallback(liBaCallbackParam);
            if (message.isSuccess()) {
                response.getWriter().print("SUCCESS");
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @ApiOperation(value="3-03-3 \u5fae\u4fe1\u9000\u6b3e\u56de\u8c03")
    @PostMapping(value={"wechat/refund/{mchId}/{refundOrderNo}"})
    @ApiVersion(value=1)
    public String wechatRefund(@PathVariable String mchId, @PathVariable String refundOrderNo, @RequestBody String xmlData) {
        log.info("\u5fae\u4fe1\u9000\u6b3e\u56de\u8c03\u56de\u8c03\u53c2\u6570mchId:{},refundOrderNo:{},xmlData\uff1a{}", new Object[]{mchId, refundOrderNo, xmlData});
        WxRefundCallbackParam wxRefundCallbackParam = new WxRefundCallbackParam();
        wxRefundCallbackParam.setMchId(mchId);
        wxRefundCallbackParam.setRefundOrderNo(refundOrderNo);
        wxRefundCallbackParam.setXmlData(xmlData);
        Message message = this.thirdPartyCallbackService.execWechatRefund(wxRefundCallbackParam);
        if (message.isSuccess()) {
            return WxPayNotifyResponse.success((String)"SUCCESS");
        }
        return WxPayNotifyResponse.success((String)"FAIL");
    }

    @ApiOperation(value="3-03-2 \u5de5\u732b\u8bdd\u8d39\u56de\u8c03")
    @PostMapping(value={"gongmao/chargePhone"})
    @ApiVersion(value=1)
    public String gongmaoChargePhoneCallback(@RequestBody String data) {
        log.info("\u6536\u5230\u5de5\u732b\u8bdd\u8d39\u56de\u8c03\uff1a{}", (Object)data);
        Map map = HttpUtil.decodeParamMap((String)data, (Charset)StandardCharsets.UTF_8);
        GongMaoCallbackParam param = (GongMaoCallbackParam)JSON.parseObject((String)JSON.toJSONString((Object)map), GongMaoCallbackParam.class);
        param.setType(PlatformBusinessTypeEnum.CHARGE_PHONE.name());
        Message message = this.thirdPartyCallbackService.execGongmaoCallback(param);
        if (message.isSuccess()) {
            return WxPayNotifyResponse.success((String)"SUCCESS");
        }
        return WxPayNotifyResponse.fail((String)"FAIL");
    }

    @ApiOperation(value="3-03-2 \u5de5\u732b\u7535\u8d39\u56de\u8c03")
    @PostMapping(value={"gongmao/electric"})
    @ApiVersion(value=1)
    public void gongmaoElectricCallback(@RequestBody String data, HttpServletResponse response) {
        log.info("\u6536\u5230\u5de5\u732b\u7535\u8d39\u56de\u8c03\uff1a{}", (Object)data);
        Map map = HttpUtil.decodeParamMap((String)data, (Charset)StandardCharsets.UTF_8);
        GongMaoCallbackParam param = (GongMaoCallbackParam)JSON.parseObject((String)JSON.toJSONString((Object)map), GongMaoCallbackParam.class);
        param.setType(PlatformBusinessTypeEnum.ELECTRIC.name());
        try {
            Message message = this.thirdPartyCallbackService.execGongmaoCallback(param);
            if (message.isSuccess()) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("success", (Object)"true");
                response.getWriter().print(JSON.toJSONString((Object)jsonObject));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

