package com.bxm.thirdparty.platform.adapter;

import com.bxm.newidea.component.bo.Message;
import com.bxm.thirdparty.platform.adapter.context.PlatformContext;
import com.bxm.thirdparty.platform.facade.request.BaseRequest;
import com.bxm.thirdparty.platform.interceptor.IThirdPartyInterceptor;
import com.bxm.thirdparty.platform.queue.QueueService;
import com.bxm.thirdparty.platform.queue.bo.QueueBO;
import com.bxm.thirdparty.platform.queue.bo.RequestBodyBO;
import com.bxm.thirdparty.platform.utils.TraceUtil;

import javax.annotation.Resource;
import java.util.List;

import static com.bxm.thirdparty.platform.context.ThreadContext.getRequestId;

/**
 * @author lowi
 * @date 2023/4/8 17:26
 */
public abstract class AbstractThirdPartyPlatformAction<T extends BaseRequest, O> {

    @Resource
    private QueueService queueService;

    protected abstract Message exec(PlatformContext<T, O> context);

    protected abstract Class<? extends BaseRequest> support();

    protected Message fallback(T t) {
        return Message.build(false).setMessage("系统繁忙，请稍后重试");
    }

    protected int retryNum() {
        return 0;
    }

    protected Integer timeout() {
        return 5000;
    }

    protected List<Class<? extends IThirdPartyInterceptor>> interceptors() {
        return null;
    }

    Message execPlatform(PlatformContext<T, O> context) {
        TraceUtil.asynReplaceRequestId(context.getRequestId());
        return exec(context);
    }

    protected abstract Message mockResult(PlatformContext<T, O> context);


    protected Message asyncResult(PlatformContext<T, O> context) {
        return Message.build();
    }


    protected void submitQueueNotify(PlatformContext<T, O> context, String jsonStr) {
        QueueBO queueBO = new QueueBO();
        queueBO.setNotifyUrl(context.getNotifyUrl());
        queueBO.setApplicationName(context.getRequest().getApplicationName());
        queueBO.setDelayTime(5);
        queueBO.setRequestId(getRequestId());
        queueBO.setRequestBodyBO(RequestBodyBO.builder()
                .requestId(getRequestId())
                .type(context.getNotifyType().name())
                .result(jsonStr)
                .build());
        queueService.submitBusinessNotify(queueBO);
    }
}
