package com.bxm.thirdparty.platform.adapter.chargephone;

import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.bo.Message;
import com.bxm.thirdparty.platform.adapter.AbstractThirdPartyPlatformAction;
import com.bxm.thirdparty.platform.adapter.context.PlatformContext;
import com.bxm.thirdparty.platform.constant.CommonConstant;
import com.bxm.thirdparty.platform.enums.PlatformBusinessTypeEnum;
import com.bxm.thirdparty.platform.facade.notify.ChargePhoneNotifyResponse;
import com.bxm.thirdparty.platform.facade.request.BaseRequest;
import com.bxm.thirdparty.platform.facade.request.ChargePhoneRequest;
import com.bxm.thirdparty.platform.facade.response.ChargePhoneTopUpResponse;
import com.bxm.thirdparty.platform.model.entity.ChargesPhoneLogEntity;
import com.bxm.thirdparty.platform.service.ThirdPartyFailService;
import com.bxm.thirdparty.platform.service.impl.bo.ThirdPartyFailBO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * @author lowi
 * @date 2023/4/4 17:13
 */
@Component
@Slf4j
public class ChargePhonePlatformAction extends AbstractThirdPartyPlatformAction<ChargePhoneRequest, ChargesPhoneLogEntity> {

    @Resource
    private IChargePhoneActionDispatcher<ChargePhoneRequest, ChargesPhoneLogEntity> iChargePhoneActionDispatcher;

    @Resource
    private ThirdPartyFailService thirdPartyFailService;

    @Override
    protected Message exec(PlatformContext context) {
        Message exec = iChargePhoneActionDispatcher.exec(context);
        log.info("充话费动作结束:{}", JSON.toJSONString(exec.getParam(CommonConstant.RESULT_DTO)));
        //因为第三方服务500的问题，丢入队列
        if (!exec.isSuccess()) {
            thirdPartyFailService.submitThirdPartyFailLog(ThirdPartyFailBO.builder()
                    .param(JSON.toJSONString(context))
                    .typeEnum(PlatformBusinessTypeEnum.CHARGE_PHONE)
                    .errorMsg(exec.getLastMessage())
                    .requestId(context.getRequestId())
                    .build());
        }
        return exec;
    }

    @Override
    protected Message mockResult(PlatformContext<ChargePhoneRequest, ChargesPhoneLogEntity> context) {
        ChargePhoneRequest request = context.getRequest();
        ChargesPhoneLogEntity orderNo = context.getOrderInfo();

        ChargePhoneTopUpResponse response = new ChargePhoneTopUpResponse();
        response.setRequestId(context.getRequestId());
        response.setMoney(request.getMoney());
        response.setPhoneNo(request.getPhoneNo());
        response.setOutOrderNo(orderNo.getOutOrderNo());
        response.setOrderNo(orderNo.getOrderNo());


        ChargePhoneNotifyResponse notifyResponse = new ChargePhoneNotifyResponse();
        notifyResponse.setRequestId(context.getRequestId());
        notifyResponse.setSuccess(true);
        notifyResponse.setOrderNo(orderNo.getOrderNo());
        notifyResponse.setOutOrderNo(orderNo.getOutOrderNo());
        submitQueueNotify(context, JSON.toJSONString(notifyResponse));

        return Message.build().addParam(CommonConstant.RESULT_DTO, response);
    }

    @Override
    public Class<? extends BaseRequest> support() {
        return ChargePhoneRequest.class;
    }

    @Override
    protected Message asyncResult(PlatformContext<ChargePhoneRequest, ChargesPhoneLogEntity> context) {
        ChargePhoneRequest request = context.getRequest();
        ChargesPhoneLogEntity orderNo = context.getOrderInfo();
        ChargePhoneTopUpResponse response = new ChargePhoneTopUpResponse();
        response.setRequestId(context.getRequestId());
        response.setMoney(request.getMoney());
        response.setPhoneNo(request.getPhoneNo());
        response.setOutOrderNo(orderNo.getOutOrderNo());
        response.setOrderNo(orderNo.getOrderNo());
        return Message.build().addParam(CommonConstant.RESULT_DTO, response);
    }
}
