package com.bxm.thirdparty.platform.adapter.context;

import com.bxm.thirdparty.platform.facade.enums.NotifyTypeEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author lowi
 * @date 2023/4/4 17:00
 */
@Data
public class PlatformContext<T, O> {

    private String requestId;

    private Boolean mock;

    @ApiModelProperty("业务方通知地址")
    private String notifyUrl;

    @ApiModelProperty("通知类型")
    private NotifyTypeEnum notifyType;

    /**
     * 订单信息
     */
    private O orderInfo;

    /**
     * 请求体
     */
    private T request;

    @ApiModelProperty("同步返回结果，例如需要支付链接，false的案例为冲话费之类的需要回调才知道结果的平台，业务方无需关心")
    private Boolean sync = Boolean.TRUE;

    /**
     * 扩展信息，不同平台可能需要一些不同的信息
     */
    private String extStr;
}
