package com.bxm.thirdparty.platform.adapter.electric;

import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.bo.Message;
import com.bxm.thirdparty.platform.adapter.AbstractThirdPartyPlatformAction;
import com.bxm.thirdparty.platform.adapter.context.PlatformContext;
import com.bxm.thirdparty.platform.constant.CommonConstant;
import com.bxm.thirdparty.platform.enums.PlatformBusinessTypeEnum;
import com.bxm.thirdparty.platform.facade.notify.ElectricNotifyResponse;
import com.bxm.thirdparty.platform.facade.request.BaseRequest;
import com.bxm.thirdparty.platform.facade.request.ElectricRequest;
import com.bxm.thirdparty.platform.facade.response.ElectricTopUpResponse;
import com.bxm.thirdparty.platform.model.entity.ElectricLogEntity;
import com.bxm.thirdparty.platform.service.ThirdPartyFailService;
import com.bxm.thirdparty.platform.service.impl.bo.ThirdPartyFailBO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * @author lowi
 * @date 2023/4/4 17:13
 */
@Component
@Slf4j
public class ElectricPlatformAction extends AbstractThirdPartyPlatformAction<ElectricRequest, ElectricLogEntity> {

    @Resource
    private IElectricActionDispatcher<ElectricRequest,ElectricLogEntity> iElectrictActionDispatcher;

    @Resource
    private ThirdPartyFailService thirdPartyFailService;

    @Override
    public Message exec(PlatformContext<ElectricRequest, ElectricLogEntity> context) {
        Message exec = iElectrictActionDispatcher.exec(context);
        log.info("充电费动作结束:{}", JSON.toJSONString(exec.getParam(CommonConstant.RESULT_DTO)));
        if (!exec.isSuccess()) {
            thirdPartyFailService.submitThirdPartyFailLog(ThirdPartyFailBO.builder()
                    .param(JSON.toJSONString(context))
                    .typeEnum(PlatformBusinessTypeEnum.ELECTRIC)
                    .errorMsg(exec.getLastMessage())
                    .requestId(context.getRequestId())
                    .build());
        }
        return exec;
    }


    @Override
    public Class<? extends BaseRequest> support() {
        return ElectricRequest.class;
    }

    @Override
    protected Message mockResult(PlatformContext<ElectricRequest, ElectricLogEntity> context) {
        ElectricRequest request = context.getRequest();
        ElectricLogEntity orderInfo = context.getOrderInfo();

        ElectricTopUpResponse response = new ElectricTopUpResponse();
        response.setSuccess(true);
        response.setRequestId(context.getRequestId());
        response.setAccount(request.getAccount());
        response.setAmount(request.getAmount());
        response.setOutOrderNo(orderInfo.getOutOrderNo());
        response.setOrderNo(orderInfo.getOrderNo());

        ElectricNotifyResponse notifyResponse = new ElectricNotifyResponse();
        notifyResponse.setSuccess(true);
        notifyResponse.setRequestId(context.getRequestId());
        notifyResponse.setOrderNo(orderInfo.getOrderNo());
        notifyResponse.setOutOrderNo(orderInfo.getOutOrderNo());
        submitQueueNotify(context, JSON.toJSONString(notifyResponse));

        return Message.build().addParam(CommonConstant.RESULT_DTO, response);
    }

    @Override
    protected Message asyncResult(PlatformContext<ElectricRequest, ElectricLogEntity> context) {
        ElectricRequest request = context.getRequest();
        ElectricLogEntity orderInfo = context.getOrderInfo();
        ElectricTopUpResponse response = new ElectricTopUpResponse();
        response.setSuccess(true);
        response.setRequestId(context.getRequestId());
        response.setAccount(request.getAccount());
        response.setAmount(request.getAmount());
        response.setOutOrderNo(orderInfo.getOutOrderNo());
        response.setOrderNo(orderInfo.getOrderNo());
        return Message.build().addParam(CommonConstant.RESULT_DTO, response);
    }
}
